/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.internal.io.text;

import java.io.File;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import standalone_spreadsheet.nbbrd.design.VisibleForTesting;

public final class FileSystemExceptions {
    @NonNull
    public static File checkSource(@NonNull File source) throws FileSystemException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        FileSystemExceptions.checkExist(source);
        FileSystemExceptions.checkIsFile(source);
        return source;
    }

    @NonNull
    public static File checkTarget(@NonNull File target) throws FileSystemException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (target.exists()) {
            FileSystemExceptions.checkIsFile(target);
        }
        return target;
    }

    @VisibleForTesting
    static void checkExist(File source) throws NoSuchFileException {
        if (!source.exists()) {
            throw new NoSuchFileException(source.getPath());
        }
    }

    @VisibleForTesting
    static void checkIsFile(File source) throws AccessDeniedException {
        if (!source.isFile()) {
            throw new AccessDeniedException(source.getPath());
        }
    }

    @NonNull
    public static Path checkSource(@NonNull Path source) throws FileSystemException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        FileSystemExceptions.checkExist(source);
        FileSystemExceptions.checkIsFile(source);
        return source;
    }

    @NonNull
    public static Path checkTarget(@NonNull Path target) throws FileSystemException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (Files.exists(target, new LinkOption[0])) {
            FileSystemExceptions.checkIsFile(target);
        }
        return target;
    }

    @VisibleForTesting
    static void checkExist(Path source) throws NoSuchFileException {
        if (!Files.exists(source, new LinkOption[0])) {
            throw new NoSuchFileException(source.toString());
        }
    }

    @VisibleForTesting
    static void checkIsFile(Path source) throws AccessDeniedException {
        if (!Files.isRegularFile(source, new LinkOption[0])) {
            throw new AccessDeniedException(source.toString());
        }
    }

    @Generated
    private FileSystemExceptions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

