/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.internal.io.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public final class InternalTextResource {
    @NonNull
    public static Stream<String> asLines(@NonNull Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        return InternalTextResource.asBufferedReader(reader).lines();
    }

    @NonNull
    public static BufferedReader asBufferedReader(@NonNull Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @NonNull
    public static String copyToString(@NonNull Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        return InternalTextResource.copy(InternalTextResource.asBufferedReader(reader), new StringBuilder()).toString();
    }

    @NonNull
    private static <A extends Appendable> A copy(@NonNull BufferedReader reader, @NonNull A appendable) throws IOException {
        int c;
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        while ((c = reader.read()) != -1) {
            appendable.append((char)c);
        }
        return appendable;
    }

    @NonNull
    public static String copyByLineToString(@NonNull Reader reader, @NonNull String separator) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        return InternalTextResource.copyByLine(InternalTextResource.asBufferedReader(reader), separator, new StringBuilder()).toString();
    }

    @NonNull
    private static <A extends Appendable> A copyByLine(@NonNull BufferedReader reader, @NonNull String separator, @NonNull A appendable) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        String line = reader.readLine();
        if (line != null) {
            appendable.append(line);
            while ((line = reader.readLine()) != null) {
                appendable.append(separator);
                appendable.append(line);
            }
        }
        return appendable;
    }

    @Generated
    private InternalTextResource() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

