/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.internal.io.text;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class NumberFormats {
    private NumberFormats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static @Nullable Number parseOrNull(@NonNull NumberFormat format, @NonNull CharSequence input) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String source = input.toString();
        ParsePosition pos = new ParsePosition(0);
        Number result = format.parse(source, pos);
        return pos.getIndex() == input.length() ? result : null;
    }

    @NonNull
    public static CharSequence normalize(@NonNull NumberFormat format, @NonNull CharSequence input) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return format instanceof DecimalFormat ? NumberFormats.normalizeDecimalFormat((DecimalFormat)format, input) : input;
    }

    private static CharSequence normalizeDecimalFormat(DecimalFormat format, CharSequence input) {
        char groupingSeparator = NumberFormats.getGroupingSeparator(format);
        return Character.isSpaceChar(groupingSeparator) ? NumberFormats.removeGroupingSpaceChars(input) : input;
    }

    private static char getGroupingSeparator(DecimalFormat format) {
        return format.getDecimalFormatSymbols().getGroupingSeparator();
    }

    private static CharSequence removeGroupingSpaceChars(CharSequence input) {
        if (input.length() < 2) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length());
        result.append(input.charAt(0));
        for (int i = 1; i < input.length() - 1; ++i) {
            if (NumberFormats.isGroupingSpaceChar(input, i)) continue;
            result.append(input.charAt(i));
        }
        result.append(input.charAt(input.length() - 1));
        return result.length() != input.length() ? result.toString() : input;
    }

    private static boolean isGroupingSpaceChar(CharSequence input, int index) {
        return Character.isSpaceChar(input.charAt(index)) && Character.isDigit(input.charAt(index - 1)) && Character.isDigit(input.charAt(index + 1));
    }
}

