/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import lombok.NonNull;
import standalone_spreadsheet.internal.io.AndThenFileParser;
import standalone_spreadsheet.internal.io.DecodingFileParser;
import standalone_spreadsheet.internal.io.FunctionalFileParser;
import standalone_spreadsheet.internal.io.LockingFileParser;
import standalone_spreadsheet.internal.io.text.LegacyFiles;
import standalone_spreadsheet.nbbrd.io.Resource;
import standalone_spreadsheet.nbbrd.io.function.IOFunction;
import standalone_spreadsheet.nbbrd.io.function.IOSupplier;

public interface FileParser<T> {
    @NonNull
    default public T parseFile(@NonNull File source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (InputStream resource = LegacyFiles.openInputStream(source);){
            T t = this.parseStream(resource);
            return t;
        }
    }

    @NonNull
    default public T parsePath(@NonNull Path source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        Optional<File> file = Resource.getFile(source);
        return file.isPresent() ? this.parseFile(file.get()) : this.parseStream(() -> Files.newInputStream(source, new OpenOption[0]));
    }

    @NonNull
    default public T parseResource(@NonNull Class<?> type, @NonNull String name) throws IOException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        try (InputStream resource = Resource.newInputStream(type, name);){
            T t = this.parseStream(resource);
            return t;
        }
    }

    @NonNull
    default public T parseStream(@NonNull IOSupplier<? extends InputStream> source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (InputStream resource = LegacyFiles.openInputStream(source);){
            T t = this.parseStream(resource);
            return t;
        }
    }

    @NonNull
    public T parseStream(@NonNull InputStream var1) throws IOException;

    @NonNull
    default public <V> FileParser<V> andThen(@NonNull IOFunction<? super T, ? extends V> after) {
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        return new AndThenFileParser<T, V>(this, after);
    }

    @NonNull
    public static <T> FileParser<T> onParsingStream(@NonNull IOFunction<? super InputStream, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return new FunctionalFileParser<T>(function);
    }

    @NonNull
    public static <T> FileParser<T> onParsingGzip(@NonNull FileParser<T> parser) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        return new DecodingFileParser<T>(parser, GZIPInputStream::new);
    }

    @NonNull
    public static <T> FileParser<T> onParsingLock(@NonNull FileParser<T> parser) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        return new LockingFileParser<T>(parser);
    }
}

