/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface IOFunction<T, R> {
    public R applyWithIO(T var1) throws IOException;

    @NonNull
    default public <V> IOFunction<V, R> compose(@NonNull IOFunction<? super V, ? extends T> before) {
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        return v -> this.applyWithIO(before.applyWithIO((Object)v));
    }

    @NonNull
    default public <V> IOFunction<T, V> andThen(@NonNull IOFunction<? super R, ? extends V> after) {
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        return t -> after.applyWithIO((R)this.applyWithIO(t));
    }

    @NonNull
    default public Function<T, R> asUnchecked() {
        return t -> {
            try {
                return this.applyWithIO(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @NonNull
    public static <T, R> Function<T, R> unchecked(@NonNull IOFunction<T, R> o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return o.asUnchecked();
    }

    @NonNull
    public static <T, R> IOFunction<T, R> checked(@NonNull Function<T, R> func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return o -> {
            try {
                return func.apply(o);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    @NonNull
    public static <T> IOFunction<T, T> identity() {
        return t -> t;
    }

    @NonNull
    public static <T, R> IOFunction<T, R> of(@Nullable R r) {
        return o -> r;
    }
}

