/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.sys;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import lombok.Generated;
import lombok.NonNull;
import standalone_spreadsheet.internal.io.text.InternalTextResource;
import standalone_spreadsheet.nbbrd.io.sys.EndOfProcessException;
import standalone_spreadsheet.nbbrd.io.text.TextResource;

public final class ProcessReader {
    @NonNull
    public static BufferedReader newReader(String ... args) throws IOException {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return ProcessReader.newReader(new ProcessBuilder(args).start());
    }

    @NonNull
    public static BufferedReader newReader(@NonNull Process process) {
        if (process == null) {
            throw new NullPointerException("process is marked non-null but is null");
        }
        return TextResource.newBufferedReader(new ProcessInputStream(process), Charset.defaultCharset().newDecoder());
    }

    @NonNull
    public static String readToString(String ... args) throws IOException {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return ProcessReader.readToString(new ProcessBuilder(args).start());
    }

    @NonNull
    public static String readToString(@NonNull Process process) throws IOException {
        if (process == null) {
            throw new NullPointerException("process is marked non-null but is null");
        }
        try (BufferedReader reader = ProcessReader.newReader(process);){
            String string = InternalTextResource.copyByLineToString(reader, System.lineSeparator());
            return string;
        }
    }

    @Generated
    private ProcessReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class ProcessInputStream
    extends InputStream {
        private final InputStream delegate;
        private final Process process;

        public ProcessInputStream(Process process) {
            this.delegate = process.getInputStream();
            this.process = process;
        }

        @Override
        public void close() throws IOException {
            try {
                this.readUntilEnd();
                this.waitForEndOfProcess();
            }
            finally {
                this.delegate.close();
            }
        }

        private void readUntilEnd() throws IOException {
            while (this.delegate.read() != -1) {
            }
        }

        private void waitForEndOfProcess() throws IOException {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            if (this.process.exitValue() != 0) {
                throw EndOfProcessException.of(this.process);
            }
        }

        @Override
        @Generated
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        @Generated
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        @Generated
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        @Generated
        public byte[] readAllBytes() throws IOException {
            return this.delegate.readAllBytes();
        }

        @Override
        @Generated
        public byte[] readNBytes(int len) throws IOException {
            return this.delegate.readNBytes(len);
        }

        @Override
        @Generated
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            return this.delegate.readNBytes(b, off, len);
        }

        @Override
        @Generated
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        @Generated
        public void skipNBytes(long n) throws IOException {
            this.delegate.skipNBytes(n);
        }

        @Override
        @Generated
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        @Generated
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        @Generated
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        @Generated
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        @Generated
        public long transferTo(OutputStream out) throws IOException {
            return this.delegate.transferTo(out);
        }
    }
}

