/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.text;

import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import standalone_spreadsheet.nbbrd.io.text.BaseProperty;
import standalone_spreadsheet.nbbrd.io.text.Formatter;
import standalone_spreadsheet.nbbrd.io.text.Parser;

public final class BooleanProperty
extends BaseProperty {
    @lombok.NonNull
    private final String key;
    private final boolean defaultValue;

    public boolean get(@lombok.NonNull Function<? super String, ? extends CharSequence> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        Boolean result = Parser.onBoolean().parse(value);
        return result != null ? result : this.defaultValue;
    }

    public boolean get(@lombok.NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::getProperty);
    }

    public boolean get(@lombok.NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::get);
    }

    public void set(@lombok.NonNull BiConsumer<? super String, ? super String> properties, boolean value) {
        String valueAsString;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (value != this.defaultValue && (valueAsString = Formatter.onBoolean().formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@lombok.NonNull Properties properties, boolean value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::setProperty, value);
    }

    public void set(@lombok.NonNull Map<String, String> properties, boolean value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::put, value);
    }

    @Generated
    private BooleanProperty(@lombok.NonNull String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Generated
    public static @NonNull BooleanProperty of(@lombok.NonNull String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new BooleanProperty(key, defaultValue);
    }

    @Override
    @lombok.NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public boolean isDefaultValue() {
        return this.defaultValue;
    }
}

