/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.text;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import standalone_spreadsheet.internal.io.text.InternalFormatter;

@FunctionalInterface
public interface Formatter<T> {
    public @Nullable CharSequence format(@Nullable T var1);

    default public @Nullable String formatAsString(@Nullable T value) {
        CharSequence result = this.format(value);
        return result != null ? result.toString() : null;
    }

    @NonNull
    default public Optional<CharSequence> formatValue(@Nullable T value) {
        return Optional.ofNullable(this.format(value));
    }

    @NonNull
    default public Optional<String> formatValueAsString(@Nullable T value) {
        return Optional.ofNullable(this.formatAsString(value));
    }

    @NonNull
    default public <Y> Formatter<Y> compose(@NonNull Function<? super Y, ? extends T> before) {
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        return o -> this.format(before.apply((Object)o));
    }

    @NonNull
    public static <T extends TemporalAccessor> Formatter<T> onDateTimeFormatter(@NonNull DateTimeFormatter formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return o -> InternalFormatter.formatTemporalAccessor(formatter, o);
    }

    @NonNull
    public static Formatter<Date> onDateFormat(@NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("dateFormat is marked non-null but is null");
        }
        return o -> InternalFormatter.formatDate(dateFormat, o);
    }

    @NonNull
    public static Formatter<Number> onNumberFormat(@NonNull NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullPointerException("numberFormat is marked non-null but is null");
        }
        return o -> InternalFormatter.formatNumber(numberFormat, o);
    }

    @NonNull
    public static <T> Formatter<T> onConstant(@Nullable CharSequence instance) {
        return o -> InternalFormatter.formatConstant(instance, o);
    }

    @NonNull
    public static <T> Formatter<T> onNull() {
        return InternalFormatter::formatNull;
    }

    @NonNull
    public static Formatter<File> onFile() {
        return InternalFormatter::formatFile;
    }

    @NonNull
    public static Formatter<Integer> onInteger() {
        return InternalFormatter::formatInteger;
    }

    @NonNull
    public static Formatter<Long> onLong() {
        return InternalFormatter::formatLong;
    }

    @NonNull
    public static Formatter<Double> onDouble() {
        return InternalFormatter::formatDouble;
    }

    @NonNull
    public static Formatter<Boolean> onBoolean() {
        return InternalFormatter::formatBoolean;
    }

    @NonNull
    public static Formatter<Character> onCharacter() {
        return InternalFormatter::formatCharacter;
    }

    @NonNull
    public static Formatter<Charset> onCharset() {
        return InternalFormatter::formatCharset;
    }

    @NonNull
    public static <T extends Enum<T>> Formatter<T> onEnum() {
        return InternalFormatter::formatEnum;
    }

    @NonNull
    public static <T extends Enum<T>> Formatter<T> onEnum(@NonNull ToIntFunction<T> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return Formatter.onInteger().compose(value -> value != null ? Integer.valueOf(function.applyAsInt(value)) : null);
    }

    @NonNull
    public static Formatter<String> onString() {
        return InternalFormatter::formatString;
    }

    @NonNull
    public static Formatter<Object> onObjectToString() {
        return InternalFormatter::formatObjectToString;
    }

    @NonNull
    public static Formatter<double[]> onDoubleArray() {
        return InternalFormatter::formatDoubleArray;
    }

    @NonNull
    public static Formatter<String[]> onStringArray() {
        return InternalFormatter::formatStringArray;
    }

    @NonNull
    public static Formatter<List<String>> onStringList(@NonNull Function<Stream<CharSequence>, String> joiner) {
        if (joiner == null) {
            throw new NullPointerException("joiner is marked non-null but is null");
        }
        return o -> InternalFormatter.formatStringList(joiner, o);
    }

    @NonNull
    public static Formatter<URL> onURL() {
        return InternalFormatter::formatURL;
    }

    @NonNull
    public static Formatter<URI> onURI() {
        return InternalFormatter::formatURI;
    }

    @NonNull
    public static <T> Formatter<T> of(@NonNull Function<? super T, ? extends CharSequence> formatter, @NonNull Consumer<? super Throwable> onError) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        return o -> InternalFormatter.formatFailsafe(formatter, onError, o);
    }

    @NonNull
    public static <T> Formatter<T> of(@NonNull Function<? super T, ? extends CharSequence> formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return Formatter.of(formatter, InternalFormatter::doNothing);
    }
}

