/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.text;

import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import standalone_spreadsheet.nbbrd.io.text.BaseProperty;
import standalone_spreadsheet.nbbrd.io.text.Formatter;
import standalone_spreadsheet.nbbrd.io.text.Parser;

public final class LongProperty
extends BaseProperty {
    @lombok.NonNull
    private final String key;
    private final long defaultValue;

    public long get(@lombok.NonNull Function<? super String, ? extends CharSequence> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        Long result = Parser.onLong().parse(value);
        return result != null ? result : this.defaultValue;
    }

    public long get(@lombok.NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::getProperty);
    }

    public long get(@lombok.NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::get);
    }

    public void set(@lombok.NonNull BiConsumer<? super String, ? super String> properties, long value) {
        String valueAsString;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (value != this.defaultValue && (valueAsString = Formatter.onLong().formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@lombok.NonNull Properties properties, long value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::setProperty, value);
    }

    public void set(@lombok.NonNull Map<String, String> properties, long value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::put, value);
    }

    @Generated
    private LongProperty(@lombok.NonNull String key, long defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Generated
    public static @NonNull LongProperty of(@lombok.NonNull String key, long defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new LongProperty(key, defaultValue);
    }

    @Override
    @lombok.NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public long getDefaultValue() {
        return this.defaultValue;
    }
}

