/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.text;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import standalone_spreadsheet.internal.io.text.InternalParser;

@FunctionalInterface
public interface Parser<T> {
    public @Nullable T parse(@Nullable CharSequence var1);

    @NonNull
    default public Optional<T> parseValue(@Nullable CharSequence input) {
        return Optional.ofNullable(this.parse(input));
    }

    @NonNull
    default public Parser<T> orElse(@NonNull Parser<T> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return o -> {
            T result = this.parse(o);
            return result != null ? result : other.parse(o);
        };
    }

    @NonNull
    default public <X> Parser<X> andThen(@NonNull Function<? super T, ? extends X> after) {
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        return o -> after.apply((T)this.parse(o));
    }

    @NonNull
    public static <T> Parser<T> onDateTimeFormatter(@NonNull DateTimeFormatter formatter, TemporalQuery<T> ... queries) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (queries == null) {
            throw new NullPointerException("queries is marked non-null but is null");
        }
        return o -> InternalParser.parseTemporalAccessor(formatter, queries, o);
    }

    @NonNull
    public static Parser<Date> onDateFormat(@NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("dateFormat is marked non-null but is null");
        }
        return o -> InternalParser.parseDate(dateFormat, o);
    }

    @NonNull
    public static Parser<Number> onNumberFormat(@NonNull NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullPointerException("numberFormat is marked non-null but is null");
        }
        return o -> InternalParser.parseNumber(numberFormat, o);
    }

    @NonNull
    public static <T> Parser<T> onConstant(@Nullable T instance) {
        return o -> InternalParser.parseConstant(instance, o);
    }

    @NonNull
    public static <T> Parser<T> onNull() {
        return InternalParser::parseNull;
    }

    @NonNull
    public static Parser<File> onFile() {
        return InternalParser::parseFile;
    }

    @NonNull
    public static Parser<Integer> onInteger() {
        return InternalParser::parseInteger;
    }

    @NonNull
    public static Parser<Long> onLong() {
        return InternalParser::parseLong;
    }

    @NonNull
    public static Parser<Double> onDouble() {
        return InternalParser::parseDouble;
    }

    @NonNull
    public static Parser<Boolean> onBoolean() {
        return InternalParser::parseBoolean;
    }

    @NonNull
    public static Parser<Character> onCharacter() {
        return InternalParser::parseCharacter;
    }

    @NonNull
    public static Parser<Charset> onCharset() {
        return InternalParser::parseCharset;
    }

    @NonNull
    public static <T extends Enum<T>> Parser<T> onEnum(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return o -> InternalParser.parseEnum(type, o);
    }

    @NonNull
    public static <T extends Enum<T>> Parser<T> onEnum(@NonNull Class<T> type, @NonNull ToIntFunction<T> function) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        Enum[] values = (Enum[])type.getEnumConstants();
        return Parser.onInteger().andThen(code -> InternalParser.parse(values, function, code));
    }

    @NonNull
    public static Parser<String> onString() {
        return InternalParser::parseString;
    }

    @NonNull
    public static Parser<double[]> onDoubleArray() {
        return InternalParser::parseDoubleArray;
    }

    @NonNull
    public static Parser<String[]> onStringArray() {
        return InternalParser::parseStringArray;
    }

    @NonNull
    public static Parser<List<String>> onStringList(@NonNull @NonNull Function<CharSequence, @NonNull Stream<String>> splitter) {
        if (splitter == null) {
            throw new NullPointerException("splitter is marked non-null but is null");
        }
        return o -> InternalParser.parseStringList(splitter, o);
    }

    @NonNull
    public static Parser<Locale> onLocale() {
        return InternalParser::parseLocale;
    }

    @NonNull
    public static Parser<URL> onURL() {
        return InternalParser::parseURL;
    }

    @NonNull
    public static Parser<URI> onURI() {
        return InternalParser::parseURI;
    }

    @NonNull
    public static <T> Parser<T> of(@NonNull Function<? super CharSequence, ? extends T> parser, @NonNull Consumer<? super Throwable> onError) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        return o -> InternalParser.parseFailsafe(parser, onError, o);
    }

    @NonNull
    public static <T> Parser<T> of(@NonNull Function<? super CharSequence, ? extends T> parser) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        return Parser.of(parser, InternalParser::doNothing);
    }
}

