/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.text;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import standalone_spreadsheet.nbbrd.io.text.BaseProperty;
import standalone_spreadsheet.nbbrd.io.text.Formatter;
import standalone_spreadsheet.nbbrd.io.text.Parser;

public final class Property<T>
extends BaseProperty {
    @lombok.NonNull
    private final String key;
    private final @Nullable T defaultValue;
    @lombok.NonNull
    private final Parser<T> parser;
    @lombok.NonNull
    private final Formatter<T> formatter;

    public @Nullable T get(@lombok.NonNull Function<? super String, ? extends CharSequence> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        T result = this.parser.parse(value);
        return result != null ? result : this.defaultValue;
    }

    public @Nullable T get(@lombok.NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::getProperty);
    }

    public @Nullable T get(@lombok.NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::get);
    }

    public void set(@lombok.NonNull BiConsumer<? super String, ? super String> properties, @Nullable T value) {
        String valueAsString;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (!Objects.equals(value, this.defaultValue) && (valueAsString = this.formatter.formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@lombok.NonNull Properties properties, T value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::setProperty, value);
    }

    public void set(@lombok.NonNull Map<String, String> properties, T value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::put, value);
    }

    @Generated
    private Property(@lombok.NonNull String key, @Nullable T defaultValue, @lombok.NonNull Parser<T> parser, @lombok.NonNull Formatter<T> formatter) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
        this.parser = parser;
        this.formatter = formatter;
    }

    @Generated
    public static <T> @NonNull Property<T> of(@lombok.NonNull String key, @Nullable T defaultValue, @lombok.NonNull Parser<T> parser, @lombok.NonNull Formatter<T> formatter) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return new Property<T>(key, defaultValue, parser, formatter);
    }

    @Override
    @lombok.NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public @Nullable T getDefaultValue() {
        return this.defaultValue;
    }
}

