/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.IOException;
import java.util.Objects;
import standalone_spreadsheet.org.dhatim.fastexcel.Writer;

class BorderElement {
    protected static final BorderElement NONE = new BorderElement(null, null);
    private final String style;
    private final String rgbColor;

    BorderElement(String style, String rgbColor) {
        this.style = style;
        this.rgbColor = rgbColor;
    }

    BorderElement updateStyle(String style) {
        return new BorderElement(style, this.rgbColor);
    }

    BorderElement updateColor(String rgbColor) {
        return new BorderElement(this.style, rgbColor);
    }

    public int hashCode() {
        return Objects.hash(this.style, this.rgbColor);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            BorderElement other = (BorderElement)obj;
            result = Objects.equals(this.style, other.style) && Objects.equals(this.rgbColor, other.rgbColor);
        } else {
            result = false;
        }
        return result;
    }

    void write(String name, Writer w) throws IOException {
        w.append("<").append(name);
        if (this.style == null && this.rgbColor == null) {
            w.append("/>");
        } else {
            if (this.style != null) {
                w.append(" style=\"").append(this.style).append('\"');
            }
            w.append('>');
            if (this.rgbColor != null) {
                w.append("<color rgb=\"").append(this.rgbColor).append("\"/>");
            }
            w.append("</").append(name).append(">");
        }
    }
}

