/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import standalone_spreadsheet.org.dhatim.fastexcel.ProtectionOption;
import standalone_spreadsheet.org.dhatim.fastexcel.Writer;

public class Protection {
    private final Map<ProtectionOption, Boolean> options;

    public Protection(Map<ProtectionOption, Boolean> options) {
        if (options == null) {
            throw new NullPointerException("Options should not be null");
        }
        this.options = options;
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protection that = (Protection)o;
        return Objects.equals(this.options, that.options);
    }

    void write(Writer w) throws IOException {
        w.append("<protection ");
        for (Map.Entry<ProtectionOption, Boolean> option : this.options.entrySet()) {
            w.append(option.getKey().getName()).append("=\"").append(option.getValue().toString()).append("\" ");
        }
        w.append("/>");
    }
}

