/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import standalone_spreadsheet.org.dhatim.fastexcel.AlternateShading;
import standalone_spreadsheet.org.dhatim.fastexcel.Cell;
import standalone_spreadsheet.org.dhatim.fastexcel.Column;
import standalone_spreadsheet.org.dhatim.fastexcel.ColumnStyleSetter;
import standalone_spreadsheet.org.dhatim.fastexcel.Comments;
import standalone_spreadsheet.org.dhatim.fastexcel.ConditionalFormatting;
import standalone_spreadsheet.org.dhatim.fastexcel.DataValidation;
import standalone_spreadsheet.org.dhatim.fastexcel.DifferentialFormat;
import standalone_spreadsheet.org.dhatim.fastexcel.DynamicBitMatrix;
import standalone_spreadsheet.org.dhatim.fastexcel.DynamicByteArray;
import standalone_spreadsheet.org.dhatim.fastexcel.Fill;
import standalone_spreadsheet.org.dhatim.fastexcel.Formula;
import standalone_spreadsheet.org.dhatim.fastexcel.HyperLink;
import standalone_spreadsheet.org.dhatim.fastexcel.HyperLinkType;
import standalone_spreadsheet.org.dhatim.fastexcel.Location;
import standalone_spreadsheet.org.dhatim.fastexcel.MarginalInformation;
import standalone_spreadsheet.org.dhatim.fastexcel.PaperSize;
import standalone_spreadsheet.org.dhatim.fastexcel.Position;
import standalone_spreadsheet.org.dhatim.fastexcel.Range;
import standalone_spreadsheet.org.dhatim.fastexcel.Ref;
import standalone_spreadsheet.org.dhatim.fastexcel.Relationships;
import standalone_spreadsheet.org.dhatim.fastexcel.RepeatColRange;
import standalone_spreadsheet.org.dhatim.fastexcel.RepeatRowRange;
import standalone_spreadsheet.org.dhatim.fastexcel.Shading;
import standalone_spreadsheet.org.dhatim.fastexcel.SheetProtectionOption;
import standalone_spreadsheet.org.dhatim.fastexcel.StyleSetter;
import standalone_spreadsheet.org.dhatim.fastexcel.Table;
import standalone_spreadsheet.org.dhatim.fastexcel.VisibilityState;
import standalone_spreadsheet.org.dhatim.fastexcel.Workbook;
import standalone_spreadsheet.org.dhatim.fastexcel.Writer;

public class Worksheet
implements Closeable {
    public static final int MAX_ROWS = 0x100000;
    public static final int MAX_COLS = 16384;
    public static final int MAX_COL_WIDTH = 255;
    public static final double DEFAULT_COL_WIDTH = 8.88671875;
    public static final double MAX_ROW_HEIGHT = 409.5;
    private final Workbook workbook;
    private final String name;
    private final List<Cell[]> rows = new ArrayList<Cell[]>();
    private final Set<Range> mergedRanges = new HashSet<Range>();
    private final DynamicBitMatrix mergedMatrix = new DynamicBitMatrix(16384, 0x100000);
    private final List<ConditionalFormatting> conditionalFormattings = new ArrayList<ConditionalFormatting>();
    private final List<DataValidation> dataValidations = new ArrayList<DataValidation>();
    private final List<AlternateShading> alternateShadingRanges = new ArrayList<AlternateShading>();
    private final List<Shading> shadingRanges = new ArrayList<Shading>();
    private final Set<Integer> hiddenRows = new HashSet<Integer>();
    private final Set<Integer> hiddenColumns = new HashSet<Integer>();
    private final DynamicByteArray groupColums = new DynamicByteArray(16384);
    private final DynamicByteArray groupRows = new DynamicByteArray(0x100000);
    private final Map<Integer, Double> colWidths = new HashMap<Integer, Double>();
    private final Map<Integer, Column> colStyles = new HashMap<Integer, Column>();
    private final Map<Integer, Double> rowHeights = new HashMap<Integer, Double>();
    final Comments comments = new Comments();
    final Map<String, Table> tables = new LinkedHashMap<String, Table>();
    private final DynamicBitMatrix tablesMatrix = new DynamicBitMatrix(16384, 0x100000);
    private boolean finished;
    private VisibilityState visibilityState;
    private boolean showGridLines = true;
    private boolean rightToLeft = false;
    private int zoomScale = 100;
    private int freezeTopRows = 0;
    private int freezeLeftColumns = 0;
    private String pageOrientation = "portrait";
    private PaperSize paperSize = PaperSize.LETTER_PAPER;
    private int pageScale = 100;
    private Boolean autoPageBreaks = false;
    private Boolean fitToPage = false;
    private int fitToWidth = 1;
    private int fitToHeight = 1;
    private int firstPageNumber = 0;
    private Boolean useFirstPageNumber = false;
    private Boolean blackAndWhite = false;
    private float headerMargin = 0.3f;
    private float footerMargin = 0.3f;
    private float topMargin = 0.75f;
    private float bottomMargin = 0.75f;
    private float leftMargin = 0.7f;
    private float rightMargin = 0.7f;
    private final Map<Position, MarginalInformation> header = new LinkedHashMap<Position, MarginalInformation>();
    private final Map<Position, MarginalInformation> footer = new LinkedHashMap<Position, MarginalInformation>();
    private RepeatRowRange repeatingRows = null;
    private RepeatColRange repeatingCols = null;
    private String passwordHash;
    private Range autoFilterRange = null;
    private Relationships relationships = new Relationships(this);
    private Map<String, Range> namedRanges = new LinkedHashMap<String, Range>();
    private Map<HyperLink, Ref> hyperlinkRanges = new LinkedHashMap<HyperLink, Ref>();
    private Set<SheetProtectionOption> sheetProtectionOptions;
    private Writer writer;
    private int flushedRows = 0;
    private String tabColor;

    Worksheet(Workbook workbook, String name) {
        this.workbook = Objects.requireNonNull(workbook);
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public RepeatRowRange getRepeatingRows() {
        return this.repeatingRows;
    }

    public Range getAutoFilterRange() {
        return this.autoFilterRange;
    }

    public RepeatColRange getRepeatingCols() {
        return this.repeatingCols;
    }

    public Map<String, Range> getNamedRanges() {
        return this.namedRanges;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    Cell cell(int r, int c) {
        if (r < 0 || r >= 0x100000 || c < 0 || c >= 16384) {
            throw new IllegalArgumentException();
        }
        this.flushedCheck(r);
        while (r >= this.rows.size()) {
            this.rows.add(null);
        }
        Cell[] row = this.rows.get(r);
        if (row == null) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            row = new Cell[columns];
            this.rows.set(r, row);
        } else if (c >= row.length) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            Cell[] tmp = new Cell[columns];
            System.arraycopy(row, 0, tmp, 0, row.length);
            row = tmp;
            this.rows.set(r, row);
        }
        if (row[c] == null) {
            row[c] = new Cell();
        }
        return row[c];
    }

    private void flushedCheck(int r) {
        if (r < this.flushedRows) {
            throw new IllegalStateException("Row " + r + " already flushed from memory.");
        }
    }

    void merge(Range range) {
        if (!this.mergedMatrix.isConflict(range.getTop(), range.getLeft(), range.getBottom(), range.getRight())) {
            if (this.mergedRanges.add(range)) {
                this.mergedMatrix.setRegion(range.getTop(), range.getLeft(), range.getBottom(), range.getRight());
            }
        } else {
            throw new IllegalArgumentException("Merge conflicted:" + range);
        }
    }

    void shadeAlternateRows(Range range, Fill fill) {
        this.alternateShadingRanges.add(new AlternateShading(range, this.getWorkbook().cacheDifferentialFormat(new DifferentialFormat(null, null, fill, null, null, null))));
    }

    void shadeRows(Range range, Fill fill, int eachNRows) {
        this.shadingRanges.add(new Shading(range, this.getWorkbook().cacheDifferentialFormat(new DifferentialFormat(null, null, fill, null, null, null)), eachNRows));
    }

    void addConditionalFormatting(ConditionalFormatting conditionalFormatting) {
        this.conditionalFormattings.add(conditionalFormatting);
    }

    void addValidation(DataValidation validation) {
        this.dataValidations.add(validation);
    }

    public void setVisibilityState(VisibilityState visibilityState) {
        this.visibilityState = visibilityState;
    }

    public VisibilityState getVisibilityState() {
        return this.visibilityState;
    }

    public void hideRow(int row) {
        this.hiddenRows.add(row);
    }

    public void showRow(int row) {
        this.hiddenRows.remove(row);
    }

    public void hideColumn(int column) {
        this.hiddenColumns.add(column);
    }

    public void showColumn(int column) {
        this.hiddenColumns.remove(column);
    }

    public void keepInActiveTab() {
        int sheetIndex = this.workbook.getIndex(this);
        this.workbook.setActiveTab(sheetIndex - 1);
    }

    public void protect(String password) {
        this.protect(password, SheetProtectionOption.DEFAULT_OPTIONS);
    }

    public void protect(String password, SheetProtectionOption ... options) {
        EnumSet<SheetProtectionOption> optionSet = EnumSet.noneOf(SheetProtectionOption.class);
        Collections.addAll(optionSet, options);
        this.protect(password, optionSet);
    }

    public void protect(String password, Set<SheetProtectionOption> options) {
        if (password == null) {
            this.sheetProtectionOptions = null;
            this.passwordHash = null;
            return;
        }
        this.sheetProtectionOptions = options;
        this.passwordHash = Worksheet.hashPassword(password);
    }

    public void setAutoFilter(int topRowNumber, int leftCellNumber, int bottomRowNumber, int rightCellNumber) {
        this.autoFilterRange = new Range(this, topRowNumber, leftCellNumber, bottomRowNumber, rightCellNumber);
    }

    public void setAutoFilter(int rowNumber, int leftCellNumber, int rightCellNumber) {
        this.setAutoFilter(rowNumber, leftCellNumber, this.rows.size() - 1, rightCellNumber);
    }

    public void removeAutoFilter() {
        this.autoFilterRange = null;
    }

    private static String hashPassword(String password) {
        byte[] passwordCharacters = password.getBytes();
        int hash = 0;
        if (passwordCharacters.length > 0) {
            int charIndex = passwordCharacters.length;
            while (charIndex-- > 0) {
                hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
                hash ^= passwordCharacters[charIndex];
            }
            hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
            hash ^= passwordCharacters.length;
            hash ^= 0xCE4B;
        }
        return Integer.toHexString(hash & 0xFFFF);
    }

    public void width(int c, double width) {
        if (width > 255.0) {
            throw new IllegalArgumentException();
        }
        this.colWidths.put(c, width);
    }

    public void rowHeight(int r, double height) {
        if (height > 409.5) {
            throw new IllegalArgumentException();
        }
        this.rowHeights.put(r, height);
    }

    public void value(int r, int c, String value) {
        this.cell(r, c).setValue(this.workbook, value);
    }

    public void value(int r, int c, Number value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, Boolean value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, Date value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, LocalDateTime value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, LocalDate value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, ZonedDateTime value) {
        this.cell(r, c).setValue(value);
    }

    public Object value(int r, int c) {
        this.flushedCheck(r);
        Cell[] row = r < this.rows.size() ? this.rows.get(r) : null;
        Cell cell = row == null || c >= row.length ? null : row[c];
        return cell == null ? null : cell.getValue();
    }

    public void hyperlink(int r, int c, HyperLink hyperLink) {
        this.value(r, c, hyperLink.getDisplayStr());
        this.addHyperlink(new Location(r, c), hyperLink);
    }

    public void formula(int r, int c, String expression) {
        this.cell(r, c).setFormula(expression);
    }

    public void inlineString(int r, int c, String value) {
        this.cell(r, c).setInlineString(value);
    }

    public StyleSetter style(int r, int c) {
        return new Range(this, r, c, r, c).style();
    }

    public ColumnStyleSetter style(int c) {
        Column column = this.colStyles.getOrDefault(c, new Column(this, c));
        this.colStyles.put(c, column);
        return column.style();
    }

    public Range range(int top, int left, int bottom, int right) {
        return new Range(this, top, left, bottom, right);
    }

    private void writeCols(Writer w, int maxCol) throws IOException {
        boolean started = false;
        for (int c = 0; c < maxCol; ++c) {
            double maxWidth = 8.88671875;
            boolean bestFit = true;
            if (this.colWidths.containsKey(c)) {
                bestFit = false;
                maxWidth = this.colWidths.get(c);
            } else {
                for (int r = 0; r < this.rows.size(); ++r) {
                    Object o;
                    boolean isCellInMergedRanges = this.mergedMatrix.get(r, c);
                    Object object = o = this.hiddenRows.contains(r) || isCellInMergedRanges ? null : this.value(r, c);
                    if (o == null || o instanceof Formula) continue;
                    int length = o.toString().length();
                    maxWidth = Math.max(maxWidth, (double)((int)((double)(length * 7 + 10) / 7.0 * 256.0)) / 256.0);
                }
            }
            boolean isHidden = this.hiddenColumns.contains(c);
            boolean hasStyle = this.colStyles.containsKey(c);
            boolean widthChanged = this.colWidths.containsKey(c) || maxWidth > 8.88671875;
            byte groupLevel = this.groupColums.get(c);
            if (!widthChanged && !isHidden && groupLevel == 0 && !hasStyle) continue;
            if (!started) {
                w.append("<cols>");
                started = true;
            }
            Integer style = this.colStyles.getOrDefault(c, Column.noStyle(this, c)).getStyle();
            Worksheet.writeCol(w, c, maxWidth, bestFit, isHidden, groupLevel, style);
        }
        if (started) {
            w.append("</cols>");
        }
    }

    private static void writeCol(Writer w, int columnIndex, double maxWidth, boolean bestFit, boolean isHidden, int groupLevel, int style) throws IOException {
        int col = columnIndex + 1;
        w.append("<col min=\"").append(col).append("\" max=\"").append(col).append("\" width=\"").append(Math.min(255.0, maxWidth));
        w.append("\" outlineLevel=\"").append(groupLevel);
        w.append("\" customWidth=\"true\" bestFit=\"").append(String.valueOf(bestFit));
        if (isHidden) {
            w.append("\" hidden=\"true");
        }
        w.append("\"");
        if (style > 0) {
            w.append(" style=\"").append(style).append("\"");
        }
        w.append("/>");
    }

    private static String getCellMark(int row, int coll) {
        char columnLetter = (char)(65 + coll);
        return String.valueOf(columnLetter) + String.valueOf(row + 1);
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    /*
     * WARNING - void declaration
     */
    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.flush();
        int index = this.workbook.getIndex(this);
        this.writer.append("</sheetData>");
        if (this.passwordHash != null) {
            void var4_18;
            this.writer.append("<sheetProtection password=\"").append(this.passwordHash).append("\" ");
            SheetProtectionOption[] sheetProtectionOptionArray = SheetProtectionOption.values();
            int n = sheetProtectionOptionArray.length;
            boolean bl = false;
            while (var4_18 < n) {
                Object option = sheetProtectionOptionArray[var4_18];
                if (((SheetProtectionOption)((Object)option)).getDefaultValue() != this.sheetProtectionOptions.contains(option)) {
                    this.writer.append(((SheetProtectionOption)((Object)option)).getName()).append("=\"").append(Boolean.toString(!((SheetProtectionOption)((Object)option)).getDefaultValue())).append("\" ");
                }
                ++var4_18;
            }
            this.writer.append("/>");
        }
        if (this.autoFilterRange != null) {
            this.writer.append("<autoFilter ref=\"").append(this.autoFilterRange.toString()).append("\">").append("</autoFilter>");
        }
        if (!this.mergedRanges.isEmpty()) {
            this.writer.append("<mergeCells>");
            for (Range range : this.mergedRanges) {
                this.writer.append("<mergeCell ref=\"").append(range.toString()).append("\"/>");
            }
            this.writer.append("</mergeCells>");
        }
        if (!this.conditionalFormattings.isEmpty()) {
            int priority = 1;
            for (ConditionalFormatting conditionalFormatting : this.conditionalFormattings) {
                conditionalFormatting.getConditionalFormattingRule().setPriority(priority++);
                conditionalFormatting.write(this.writer);
            }
        }
        for (AlternateShading alternateShading : this.alternateShadingRanges) {
            alternateShading.write(this.writer);
        }
        for (Shading shading : this.shadingRanges) {
            shading.write(this.writer);
        }
        if (!this.dataValidations.isEmpty()) {
            this.writer.append("<dataValidations count=\"").append(this.dataValidations.size()).append("\">");
            for (DataValidation dataValidation : this.dataValidations) {
                dataValidation.write(this.writer);
            }
            this.writer.append("</dataValidations>");
        }
        if (!this.hyperlinkRanges.isEmpty()) {
            this.writer.append("<hyperlinks>");
            for (Map.Entry entry : this.hyperlinkRanges.entrySet()) {
                HyperLink hyperLink = (HyperLink)entry.getKey();
                this.writer.append("<hyperlink ");
                Ref ref = (Ref)entry.getValue();
                this.writer.append("ref=\"" + ref.toString() + "\" ");
                if (hyperLink.getHyperLinkType().equals((Object)HyperLinkType.EXTERNAL)) {
                    String rId = this.relationships.setHyperLinkRels(hyperLink.getLinkStr(), "External");
                    this.writer.append("r:id=\"" + rId + "\" ");
                } else {
                    this.writer.append("location=\"").append(hyperLink.getLinkStr()).append("\"");
                }
                this.writer.append("/>");
            }
            this.writer.append("</hyperlinks>");
        }
        String margins = "<pageMargins bottom=\"" + this.bottomMargin + "\" footer=\"" + this.footerMargin + "\" header=\"" + this.headerMargin + "\" left=\"" + this.leftMargin + "\" right=\"" + this.rightMargin + "\" top=\"" + this.topMargin + "\"/>";
        this.writer.append(margins);
        this.writer.append("<pageSetup").append(" paperSize=\"" + this.paperSize.xmlValue + "\"").append(" scale=\"" + this.pageScale + "\"").append(" fitToWidth=\"" + this.fitToWidth + "\"").append(" fitToHeight=\"" + this.fitToHeight + "\"").append(" firstPageNumber=\"" + this.firstPageNumber + "\"").append(" useFirstPageNumber=\"" + this.useFirstPageNumber.toString() + "\"").append(" blackAndWhite=\"" + this.blackAndWhite.toString() + "\"").append(" orientation=\"" + this.pageOrientation + "\"").append("/>");
        this.writer.append("<headerFooter differentFirst=\"false\" differentOddEven=\"false\">");
        this.writer.append("<oddHeader>");
        for (MarginalInformation marginalInformation : this.header.values()) {
            marginalInformation.write(this.writer);
        }
        this.writer.append("</oddHeader>");
        this.writer.append("<oddFooter>");
        for (MarginalInformation marginalInformation : this.footer.values()) {
            marginalInformation.write(this.writer);
        }
        this.writer.append("</oddFooter></headerFooter>");
        if (!this.comments.isEmpty()) {
            this.writer.append("<drawing r:id=\"d\"/>");
            this.writer.append("<legacyDrawing r:id=\"v\"/>");
        }
        if (!this.tables.isEmpty()) {
            this.writer.append("<tableParts count=\"" + this.tables.size() + "\">");
            for (Map.Entry<String, Table> entry : this.tables.entrySet()) {
                this.writer.append("<tablePart r:id=\"" + entry.getKey() + "\"/>");
            }
            this.writer.append("</tableParts>");
        }
        this.writer.append("</worksheet>");
        this.workbook.endFile();
        if (!this.comments.isEmpty()) {
            this.workbook.writeFile("xl/comments" + index + ".xml", this.comments::writeComments);
            this.workbook.writeFile("xl/drawings/vmlDrawing" + index + ".vml", this.comments::writeVmlDrawing);
            this.workbook.writeFile("xl/drawings/drawing" + index + ".xml", this.comments::writeDrawing);
            this.relationships.setCommentsRels(index);
        }
        for (Map.Entry<String, Table> entry : this.tables.entrySet()) {
            Table table = entry.getValue();
            this.workbook.writeFile("xl/tables/table" + table.index + ".xml", table::write);
        }
        if (!this.relationships.isEmpty()) {
            this.workbook.writeFile("xl/worksheets/_rels/sheet" + index + ".xml.rels", this.relationships::write);
        }
        this.rows.clear();
        this.finished = true;
    }

    public void flush() throws IOException {
        if (this.writer == null) {
            int index = this.workbook.getIndex(this);
            this.writer = this.workbook.beginFile("xl/worksheets/sheet" + index + ".xml");
            this.writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writer.append("<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
            this.writer.append("<sheetPr filterMode=\"false\">" + (this.tabColor != null ? "<tabColor rgb=\"" + this.tabColor + "\"/>" : "") + "<pageSetUpPr fitToPage=\"" + this.fitToPage + "\" autoPageBreaks=\"" + this.autoPageBreaks + "\"/></sheetPr>");
            this.writer.append("<dimension ref=\"A1\"/>");
            this.writer.append("<sheetViews><sheetView workbookViewId=\"0\"");
            if (!this.showGridLines) {
                this.writer.append(" showGridLines=\"false\"");
            }
            if (this.rightToLeft) {
                this.writer.append(" rightToLeft=\"true\"");
            }
            if (this.zoomScale != 100) {
                this.writer.append(" zoomScale=\"").append(this.zoomScale).append("\"");
            }
            this.writer.append(">");
            if (this.freezeLeftColumns > 0 || this.freezeTopRows > 0) {
                this.writeFreezePane(this.writer);
            }
            this.writer.append("</sheetView>");
            this.writer.append("</sheetViews><sheetFormatPr defaultRowHeight=\"15.0\"/>");
            int nbCols = this.rows.stream().filter(Objects::nonNull).mapToInt(r -> ((Cell[])r).length).max().orElse(0);
            int maxHideCol = this.hiddenColumns.stream().mapToInt(a -> a).max().orElse(0);
            int maxStyleCol = this.colStyles.values().stream().mapToInt(Column::getColNumber).max().orElse(0);
            int maxNoZeroIndex = this.groupColums.getMaxNoZeroIndex();
            if (nbCols > 0 || !this.hiddenColumns.isEmpty() || maxNoZeroIndex != -1 || !this.colStyles.isEmpty()) {
                int maxCol = Math.max(nbCols, Math.max(Math.max(maxHideCol, maxNoZeroIndex), maxStyleCol) + 1);
                this.writeCols(this.writer, maxCol);
            }
            this.writer.append("<sheetData>");
        }
        int nbRows = this.rows.size();
        int maxHideRow = this.hiddenRows.stream().mapToInt(a -> a).max().orElse(0);
        int maxGroupRow = this.groupRows.getMaxNoZeroIndex();
        int maxRow = Math.max(nbRows, Math.max(maxGroupRow, maxHideRow) + 1);
        for (int r2 = this.flushedRows; r2 < maxRow; ++r2) {
            boolean notEmptyRow = r2 < this.rows.size();
            Cell[] row = notEmptyRow ? this.rows.get(r2) : null;
            boolean isHidden = this.hiddenRows.contains(r2);
            byte groupLevel = this.groupRows.get(r2);
            if (row != null || isHidden || groupLevel != 0) {
                Worksheet.writeRow(this.writer, r2, isHidden, groupLevel, this.rowHeights.get(r2), row);
            }
            if (!notEmptyRow) continue;
            this.rows.set(r2, null);
        }
        this.flushedRows = maxRow - 1;
        this.writer.flush();
    }

    private void writeFreezePane(Writer w) throws IOException {
        String activePane = this.freezeLeftColumns == 0 ? "bottomLeft" : (this.freezeTopRows == 0 ? "topRight" : "bottomRight");
        String freezePane = "<pane xSplit=\"" + this.freezeLeftColumns + "\" ySplit=\"" + this.freezeTopRows + "\" topLeftCell=\"" + Worksheet.getCellMark(this.freezeTopRows, this.freezeLeftColumns) + "\" activePane=\"" + activePane + "\" state=\"frozen\"/>";
        w.append(freezePane);
        String topLeftPane = "<selection pane=\"topLeft\" activeCell=\"" + Worksheet.getCellMark(0, 0) + "\" activeCellId=\"0\" sqref=\"" + Worksheet.getCellMark(0, 0) + "\"/>";
        w.append(topLeftPane);
        if (this.freezeLeftColumns != 0) {
            String topRightPane = "<selection pane=\"topRight\" activeCell=\"" + Worksheet.getCellMark(0, this.freezeLeftColumns) + "\" activeCellId=\"0\" sqref=\"" + Worksheet.getCellMark(0, this.freezeLeftColumns) + "\"/>";
            w.append(topRightPane);
        }
        if (this.freezeTopRows != 0) {
            String bottomLeftPane = "<selection pane=\"bottomLeft\" activeCell=\"" + Worksheet.getCellMark(this.freezeTopRows, 0) + "\" activeCellId=\"0\" sqref=\"" + Worksheet.getCellMark(this.freezeTopRows, 0) + "\"/>";
            w.append(bottomLeftPane);
        }
        if (this.freezeLeftColumns != 0 && this.freezeTopRows != 0) {
            String bottomRightPane = "<selection pane=\"bottomRight\" activeCell=\"" + Worksheet.getCellMark(this.freezeTopRows, this.freezeLeftColumns) + "\" activeCellId=\"0\" sqref=\"" + Worksheet.getCellMark(this.freezeTopRows, this.freezeLeftColumns) + "\"/>";
            w.append(bottomRightPane);
        }
    }

    private static void writeRow(Writer w, int r, boolean isHidden, byte groupLevel, Double rowHeight, Cell ... row) throws IOException {
        w.append("<row r=\"").append(r + 1).append("\"");
        if (isHidden) {
            w.append(" hidden=\"true\"");
        }
        if (rowHeight != null) {
            w.append(" ht=\"").append(rowHeight).append("\"").append(" customHeight=\"1\"");
        }
        if (groupLevel != 0) {
            w.append(" outlineLevel=\"").append(groupLevel).append("\"");
        }
        w.append(">");
        if (null != row) {
            for (int c = 0; c < row.length; ++c) {
                if (row[c] == null) continue;
                row[c].write(w, r, c);
            }
        }
        w.append("</row>");
    }

    public void comment(int r, int c, String comment) {
        this.comments.set(r, c, comment);
    }

    public void hideGridLines() {
        this.showGridLines = false;
    }

    public void rightToLeft() {
        this.rightToLeft = true;
    }

    public void setZoom(int zoomPercent) {
        if (10 > zoomPercent || zoomPercent > 400) {
            throw new IllegalArgumentException("zoom must be within 10 and 400 inclusive");
        }
        this.zoomScale = zoomPercent;
    }

    public void setAutoPageBreaks(Boolean autoPageBreaks) {
        this.autoPageBreaks = autoPageBreaks;
    }

    public void setFitToPage(Boolean fitToPage) {
        this.fitToPage = fitToPage;
    }

    public void freezePane(int nLeftColumns, int nTopRows) {
        this.freezeLeftColumns = nLeftColumns;
        this.freezeTopRows = nTopRows;
    }

    public void unfreeze() {
        this.freezeLeftColumns = 0;
        this.freezeTopRows = 0;
    }

    public void headerMargin(float margin) {
        this.headerMargin = margin;
    }

    public void footerMargin(float margin) {
        this.footerMargin = margin;
    }

    public void topMargin(float margin) {
        this.topMargin = margin;
    }

    public void bottomMargin(float margin) {
        this.bottomMargin = margin;
    }

    public void leftMargin(float margin) {
        this.leftMargin = margin;
    }

    public void rightMargin(float margin) {
        this.rightMargin = margin;
    }

    public void pageOrientation(String orientation) {
        this.pageOrientation = orientation;
    }

    public void paperSize(PaperSize size) {
        this.paperSize = size;
    }

    public void pageScale(int scale) {
        this.pageScale = scale;
    }

    public void firstPageNumber(int pageNumber) {
        this.firstPageNumber = pageNumber;
        this.useFirstPageNumber = true;
    }

    public void fitToHeight(Short fitToHeight) {
        this.fitToPage = true;
        this.fitToHeight = fitToHeight.shortValue();
    }

    public void fitToWidth(Short fitToWidth) {
        this.fitToPage = true;
        this.fitToWidth = fitToWidth.shortValue();
    }

    public void printInBlackAndWhite() {
        this.blackAndWhite = true;
    }

    public void printInColor() {
        this.blackAndWhite = false;
    }

    public void repeatRows(int startRow, int endRow) {
        this.repeatingRows = new RepeatRowRange(startRow, endRow);
    }

    public void repeatRows(int row) {
        this.repeatingRows = new RepeatRowRange(row, row);
    }

    public void repeatCols(int startCol, int endCol) {
        this.repeatingCols = new RepeatColRange(startCol, endCol);
    }

    public void repeatCols(int col) {
        this.repeatingCols = new RepeatColRange(col, col);
    }

    public void footer(String text, Position position) {
        this.footer.put(position, new MarginalInformation(text, position));
    }

    public void footer(String text, Position position, int fontSize) {
        this.footer.put(position, new MarginalInformation(text, position).withFontSize(fontSize));
    }

    public void footer(String text, Position position, String fontName, int fontSize) {
        this.footer.put(position, new MarginalInformation(text, position).withFont(fontName).withFontSize(fontSize));
    }

    public void header(String text, Position position, String fontName, int fontSize) {
        this.header.put(position, new MarginalInformation(text, position).withFont(fontName).withFontSize(fontSize));
    }

    public void header(String text, Position position, int fontSize) {
        this.header.put(position, new MarginalInformation(text, position).withFontSize(fontSize));
    }

    public void header(String text, Position position) {
        this.header.put(position, new MarginalInformation(text, position));
    }

    public void addNamedRange(Range range, String name) {
        this.namedRanges.put(name, range);
    }

    void addHyperlink(Ref ref, HyperLink hyperLink) {
        this.hyperlinkRanges.put(hyperLink, ref);
    }

    Table addTable(Range range, String ... headers) {
        if (!this.tablesMatrix.isConflict(range.getTop(), range.getLeft(), range.getBottom(), range.getRight())) {
            int tableIndex = this.getWorkbook().nextTableIndex();
            String rId = this.relationships.setTableRels(tableIndex);
            Table table = new Table(tableIndex, range, headers);
            this.tables.put(rId, table);
            this.tablesMatrix.setRegion(range.getTop(), range.getLeft(), range.getBottom(), range.getRight());
            return table;
        }
        throw new IllegalArgumentException("Table conflicted:" + range);
    }

    public void groupCols(int from, int to) {
        IntStream.rangeClosed(Math.min(from, to), Math.max(from, to)).forEach(this.groupColums::increase);
    }

    public void groupRows(int from, int to) {
        IntStream.rangeClosed(Math.min(from, to), Math.max(from, to)).forEach(this.groupRows::increase);
    }

    public void setTabColor(String rgbColor) {
        this.tabColor = rgbColor;
    }
}

