/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.jsoup.select;

import java.util.Collection;
import java.util.IdentityHashMap;
import org.jspecify.annotations.Nullable;
import standalone_spreadsheet.org.jsoup.helper.Validate;
import standalone_spreadsheet.org.jsoup.nodes.Element;
import standalone_spreadsheet.org.jsoup.select.Collector;
import standalone_spreadsheet.org.jsoup.select.Elements;
import standalone_spreadsheet.org.jsoup.select.Evaluator;
import standalone_spreadsheet.org.jsoup.select.QueryParser;

public class Selector {
    private Selector() {
    }

    public static Elements select(String query, Element root) {
        Validate.notEmpty(query);
        return Selector.select(QueryParser.parse(query), root);
    }

    public static Elements select(Evaluator evaluator, Element root) {
        Validate.notNull(evaluator);
        Validate.notNull(root);
        return Collector.collect(evaluator, root);
    }

    public static Elements select(String query, Iterable<Element> roots) {
        Validate.notEmpty(query);
        Validate.notNull(roots);
        Evaluator evaluator = QueryParser.parse(query);
        Elements elements = new Elements();
        IdentityHashMap<Element, Boolean> seenElements = new IdentityHashMap<Element, Boolean>();
        for (Element root : roots) {
            Elements found = Selector.select(evaluator, root);
            for (Element el : found) {
                if (seenElements.put(el, Boolean.TRUE) != null) continue;
                elements.add(el);
            }
        }
        return elements;
    }

    static Elements filterOut(Collection<Element> elements, Collection<Element> outs) {
        Elements output = new Elements();
        for (Element el : elements) {
            boolean found = false;
            for (Element out : outs) {
                if (!el.equals(out)) continue;
                found = true;
                break;
            }
            if (found) continue;
            output.add(el);
        }
        return output;
    }

    public static @Nullable Element selectFirst(String cssQuery, Element root) {
        Validate.notEmpty(cssQuery);
        return Collector.findFirst(QueryParser.parse(cssQuery), root);
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String msg) {
            super(msg);
        }

        public SelectorParseException(String msg, Object ... msgArgs) {
            super(String.format(msg, msgArgs));
        }

        public SelectorParseException(Throwable cause, String msg, Object ... msgArgs) {
            super(String.format(msg, msgArgs), cause);
        }
    }
}

