/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neuroph.imgrec.filter.FilteredImage;
import org.neuroph.imgrec.filter.ImageFilter;

public class ImageFilterChain
implements ImageFilter<BufferedImage>,
Serializable {
    private List<ImageFilter> filters = new ArrayList<ImageFilter>();
    private String chainName;

    public void addFilter(ImageFilter filter) {
        this.filters.add(filter);
    }

    public boolean removeFilter(ImageFilter filter) {
        return this.filters.remove(filter);
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        BufferedImage tempImage = image;
        for (ImageFilter filter : this.filters) {
            BufferedImage filteredImage;
            tempImage = filteredImage = filter.apply(tempImage);
        }
        return tempImage;
    }

    public List<FilteredImage> processImageTest(BufferedImage image) {
        ArrayList<FilteredImage> list = new ArrayList<FilteredImage>();
        BufferedImage tempImage = image;
        for (ImageFilter filter : this.filters) {
            BufferedImage processedImage = filter.apply(tempImage);
            String filterName = filter.toString();
            FilteredImage filteredImage = new FilteredImage(processedImage, filterName);
            list.add(filteredImage);
            tempImage = processedImage;
        }
        return list;
    }

    public List<ImageFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ImageFilter> filters) {
        this.filters = filters;
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public String toString() {
        return this.chainName;
    }
}

