/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class Dilation
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private transient int width;
    private transient int height;
    public static final int WHITE = 255;
    public static final int BLACK = 0;
    private final int radius;

    public Dilation() {
        this.radius = 2;
    }

    public Dilation(int radius) {
        this.radius = radius;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(this.width, this.height, this.originalImage.getType());
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int color = new Color(this.originalImage.getRGB(x, y)).getRed();
                if (color == 0) {
                    this.convolve(x, y);
                    continue;
                }
                int alpha = new Color(this.originalImage.getRGB(x, y)).getAlpha();
                int rgb = ImageUtilities.argbToColor(alpha, 255, 255, 255);
                this.filteredImage.setRGB(x, y, rgb);
            }
        }
        return this.filteredImage;
    }

    private void convolve(int xCenter, int yCenter) {
        for (int x = xCenter - this.radius; x <= xCenter + this.radius; ++x) {
            for (int y = yCenter - this.radius; y <= yCenter + this.radius; ++y) {
                if (x < 0 || y < 0 || x >= this.width || y >= this.height) continue;
                int alpha = new Color(this.originalImage.getRGB(x, y)).getAlpha();
                int rgb = ImageUtilities.argbToColor(alpha, 0, 0, 0);
                this.filteredImage.setRGB(x, y, rgb);
            }
        }
    }

    public String toString() {
        return "Dilation";
    }
}

