/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.LinkedList;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class EraseBlackBorderFilter
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;

    @Override
    public BufferedImage apply(BufferedImage image) {
        int color;
        int j;
        int i;
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        int centerI = width / 2;
        int centerJ = height / 2;
        int lengthI = width / 4;
        int lengthJ = height / 6;
        int startI = centerI - lengthI / 2;
        int goalI = centerI + lengthI / 2;
        int startJ = centerJ - lengthJ / 2;
        int goalJ = centerJ + lengthJ / 2;
        boolean[][] visited = new boolean[width][height];
        for (i = startI; i < goalI; ++i) {
            for (j = startJ; j < goalJ; ++j) {
                color = new Color(this.originalImage.getRGB(i, j)).getRed();
                if (color != 0 || visited[i][j]) continue;
                this.BFS(i, j, visited);
            }
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                if (!visited[i][j]) {
                    int white = 255;
                    color = ImageUtilities.argbToColor(alpha, white, white, white);
                    this.filteredImage.setRGB(i, j, color);
                    continue;
                }
                int black = 0;
                color = ImageUtilities.argbToColor(alpha, black, black, black);
                this.filteredImage.setRGB(i, j, color);
            }
        }
        return this.filteredImage;
    }

    public void BFS(int startI, int startJ, boolean[][] visited) {
        LinkedList<String> queue = new LinkedList<String>();
        String positions = startI + " " + startJ;
        visited[startI][startJ] = true;
        queue.addLast(positions);
        while (!queue.isEmpty()) {
            String pos = (String)queue.removeFirst();
            String[] posArray = pos.split(" ");
            int x = Integer.parseInt(posArray[0]);
            int y = Integer.parseInt(posArray[1]);
            visited[x][y] = true;
            for (int i = x - 1; i <= x + 1; ++i) {
                for (int j = y - 1; j <= y + 1; ++j) {
                    int color;
                    if (i < 0 || j < 0 || i >= this.originalImage.getWidth() || j >= this.originalImage.getHeight() || i == x || j == y || visited[i][j] || (color = new Color(this.originalImage.getRGB(i, j)).getRed()) != 0) continue;
                    visited[i][j] = true;
                    String tmpPos = i + " " + j;
                    queue.addLast(tmpPos);
                }
            }
        }
    }

    public String toString() {
        return "Erase Black Border Filter";
    }
}

