/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class GaussianBluring
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private int radius = 7;
    private double sigma = 10.0;
    private double[][] kernel;

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        int oldWidth = image.getWidth();
        int oldHeight = image.getHeight();
        int width = image.getWidth() - 2 * this.radius;
        int height = image.getHeight() - 2 * this.radius;
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        this.createKernel();
        for (int i = this.radius; i < oldWidth - this.radius; ++i) {
            for (int j = this.radius; j < oldHeight - this.radius; ++j) {
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int newColor = this.getNewColor(i, j);
                int rgb = ImageUtilities.argbToColor(alpha, newColor, newColor, newColor);
                int x = i - this.radius;
                int y = j - this.radius;
                this.filteredImage.setRGB(x, y, rgb);
            }
        }
        return this.filteredImage;
    }

    protected void createKernel() {
        int size = this.radius * 2 + 1;
        int center = this.radius;
        this.kernel = new double[size][size];
        for (int x = 0; x < this.kernel.length; ++x) {
            for (int y = 0; y < this.kernel[0].length; ++y) {
                int distanceX = Math.abs(center - x);
                int distanceY = Math.abs(center - y);
                this.kernel[x][y] = this.gaussianFormula(distanceX, distanceY);
            }
        }
        double noralizationValue = this.getNormalizationValue(this.kernel);
        for (int i = 0; i < this.kernel.length; ++i) {
            for (int j = 0; j < this.kernel[0].length; ++j) {
                this.kernel[i][j] = this.kernel[i][j] * noralizationValue;
            }
        }
    }

    private double gaussianFormula(double x, double y) {
        double one = 1.0;
        double value = one / (Math.PI * 2 * this.sigma * this.sigma);
        double exp = -(x * x + y * y) / (2.0 * this.sigma * this.sigma);
        exp = Math.pow(Math.E, exp);
        return value *= exp;
    }

    private double getNormalizationValue(double[][] kernel) {
        double sum = 0.0;
        for (int i = 0; i < kernel.length; ++i) {
            for (int j = 0; j < kernel[0].length; ++j) {
                sum += kernel[i][j];
            }
        }
        double one = 1.0;
        return one / sum;
    }

    private int getNewColor(int x, int y) {
        if (!this.checkConditios(x, y)) {
            return new Color(this.originalImage.getRGB(x, y)).getRed();
        }
        int size = 2 * this.radius + 1;
        double[][] matrix = new double[size][size];
        int newI = 0;
        int newJ = 0;
        for (int i = x - this.radius; i <= x + this.radius; ++i) {
            for (int j = y - this.radius; j <= y + this.radius; ++j) {
                int oldColor = new Color(this.originalImage.getRGB(i, j)).getRed();
                matrix[newI][newJ] = (double)oldColor * this.kernel[newI][newJ];
                ++newJ;
            }
            ++newI;
            newJ = 0;
        }
        double sum = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                sum += matrix[i][j];
            }
        }
        return (int)Math.round(sum);
    }

    public boolean checkConditios(int x, int y) {
        return x - this.radius >= 0 && x + this.radius < this.originalImage.getWidth() && y - this.radius >= 0 && y + this.radius < this.originalImage.getHeight();
    }

    public String toString() {
        return "Gaussian bluring";
    }

    public void setRadius(int radius) {
        if (radius % 2 != 0) {
            this.radius = radius;
        }
        this.radius = radius - 1;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }
}

