/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class GaussianNoise
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private double mean = 0.0;
    private double sigma = 30.0;

    @Override
    public BufferedImage apply(BufferedImage image) {
        double variance = this.sigma * this.sigma;
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                while (a == 0.0) {
                    a = Math.random();
                }
                b = Math.random();
                double x = Math.sqrt(-2.0 * Math.log(a)) * Math.cos(Math.PI * 2 * b);
                double noise = this.mean + Math.sqrt(variance) * x;
                int gray = new Color(this.originalImage.getRGB(i, j)).getRed();
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                double color = (double)gray + noise;
                if (color > 255.0) {
                    color = 255.0;
                }
                if (color < 0.0) {
                    color = 0.0;
                }
                int newColor = (int)Math.round(color);
                int newRGB = ImageUtilities.argbToColor(alpha, newColor, newColor, newColor);
                this.filteredImage.setRGB(i, j, newRGB);
            }
        }
        return this.filteredImage;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public String toString() {
        return "Gaussian noise";
    }
}

