/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class GenericConvolution
implements ImageFilter<BufferedImage> {
    private BufferedImage originalImage;
    private BufferedImage filteredImage;
    private double[][] kernel;
    private boolean normalize;

    public GenericConvolution(double[][] kernel) {
        this.kernel = kernel;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        int radius = this.kernel.length / 2;
        if (this.normalize) {
            this.normalizeKernel();
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double result = this.convolve(x, y, radius);
                int gray = (int)Math.round(result);
                int alpha = new Color(this.originalImage.getRGB(x, y)).getAlpha();
                int rgb = ImageUtilities.argbToColor(alpha, gray, gray, gray);
                this.filteredImage.setRGB(x, y, rgb);
            }
        }
        return this.filteredImage;
    }

    protected double convolve(int xCenter, int yCenter, int radius) {
        double sum = 0.0;
        int kernelX = 0;
        for (int x = xCenter - radius; x <= xCenter + radius; ++x) {
            int kernelY = 0;
            for (int y = yCenter - radius; y <= yCenter + radius; ++y) {
                if (x >= 0 && x < this.originalImage.getWidth() && y > 0 && y < this.originalImage.getHeight()) {
                    int color = new Color(this.originalImage.getRGB(x, y)).getRed();
                    sum += (double)color * this.kernel[kernelX][kernelY];
                }
                ++kernelY;
            }
            ++kernelX;
        }
        return sum;
    }

    private void normalizeKernel() {
        int j;
        int i;
        int kernelSum = 0;
        for (i = 0; i < this.kernel.length; ++i) {
            for (j = 0; j < this.kernel.length; ++j) {
                kernelSum = (int)((double)kernelSum + this.kernel[i][j]);
            }
        }
        for (i = 0; i < this.kernel.length; ++i) {
            for (j = 0; j < this.kernel.length; ++j) {
                this.kernel[i][j] = this.kernel[i][j] / (double)kernelSum;
            }
        }
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setKernel(double[][] kernel) {
        if (kernel.length % 2 == 0) {
            throw new RuntimeException("Kernel cannot be even number!");
        }
        this.kernel = kernel;
    }

    public String toString() {
        return "Generic convolution";
    }
}

