/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;
import org.neuroph.imgrec.filter.impl.OtsuBinarizeFilter;

public class MaskSegmentationFilter
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        OtsuBinarizeFilter obf = new OtsuBinarizeFilter();
        BufferedImage tempImage = obf.apply(this.originalImage);
        int white = 255;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int gray = new Color(this.originalImage.getRGB(i, j)).getRed();
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int discreteColor = new Color(tempImage.getRGB(i, j)).getRed();
                int newColor = discreteColor == white ? gray : white;
                newColor = ImageUtilities.argbToColor(alpha, newColor, newColor, newColor);
                this.filteredImage.setRGB(i, j, newColor);
            }
        }
        return this.filteredImage;
    }

    public String toString() {
        return "Mask Segmentation Filter";
    }
}

