/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class MeanFilter
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private int radius;
    private transient int imageWidth;
    private transient int imageHeight;

    public MeanFilter() {
        this.radius = 1;
    }

    public MeanFilter(int radius) {
        this.radius = radius;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        this.imageWidth = this.originalImage.getWidth();
        this.imageHeight = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(this.imageWidth, this.imageHeight, this.originalImage.getType());
        for (int x = 0; x < this.imageWidth; ++x) {
            for (int y = 0; y < this.imageHeight; ++y) {
                int mean = this.findMeanPixelColor(x, y);
                int alpha = new Color(this.originalImage.getRGB(x, y)).getAlpha();
                int rgb = ImageUtilities.argbToColor(alpha, mean, mean, mean);
                this.filteredImage.setRGB(x, y, rgb);
            }
        }
        return this.filteredImage;
    }

    private int findMeanPixelColor(int centerX, int centerY) {
        double sum = 0.0;
        int numPixels = (2 * this.radius + 1) * (2 * this.radius + 1);
        for (int x = centerX - this.radius; x <= centerX + this.radius; ++x) {
            for (int y = centerY - this.radius; y <= centerY + this.radius; ++y) {
                if (x <= 0 || x >= this.imageWidth || y <= 0 || y >= this.imageHeight) continue;
                int color = new Color(this.originalImage.getRGB(x, y)).getRed();
                sum += (double)color;
            }
        }
        return (int)Math.round(sum / (double)numPixels);
    }

    public String toString() {
        return "Mean Filter";
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }
}

