/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Arrays;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class MedianFilter
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private int radius;
    private transient int imageWidth;
    private transient int imageHeight;

    public MedianFilter() {
        this.radius = 1;
    }

    public MedianFilter(int radius) {
        this.radius = radius;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        this.imageWidth = this.originalImage.getWidth();
        this.imageHeight = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(this.imageWidth, this.imageHeight, this.originalImage.getType());
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                int[] arrayOfPixels = this.getArrayOfPixels(i, j);
                int median = this.findMedianPixelColor(arrayOfPixels);
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int newColor = ImageUtilities.argbToColor(alpha, median, median, median);
                this.filteredImage.setRGB(i, j, newColor);
            }
        }
        return this.filteredImage;
    }

    public int[] getArrayOfPixels(int x, int y) {
        int startX = x - this.radius;
        int goalX = x + this.radius;
        int startY = y - this.radius;
        int goalY = y + this.radius;
        if (startX < 0) {
            startX = 0;
        }
        if (goalX > this.originalImage.getWidth() - 1) {
            goalX = this.originalImage.getWidth() - 1;
        }
        if (startY < 0) {
            startY = 0;
        }
        if (goalY > this.originalImage.getHeight() - 1) {
            goalY = this.originalImage.getHeight() - 1;
        }
        int arraySize = (goalX - startX + 1) * (goalY - startY + 1);
        int[] pixels = new int[arraySize];
        int position = 0;
        for (int p = startX; p <= goalX; ++p) {
            for (int q = startY; q <= goalY; ++q) {
                int color;
                pixels[position] = color = new Color(this.originalImage.getRGB(p, q)).getRed();
                ++position;
            }
        }
        return pixels;
    }

    private int findMedianPixelColor(int[] arrayOfPixels) {
        Arrays.sort(arrayOfPixels);
        int middle = arrayOfPixels.length / 2;
        return arrayOfPixels[middle];
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public String toString() {
        return "Median Filter";
    }
}

