/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class NormalizationFilter
implements ImageFilter<BufferedImage> {
    private BufferedImage originalImage;
    private BufferedImage filteredImage;
    private int blockSize = 5;
    private double targetMean = 0.0;
    private double targetVariance = 1.0;
    private int mean;
    private int var;
    private int width;
    private int height;
    private int[][] imageMatrix;

    @Override
    public BufferedImage apply(BufferedImage image) {
        int y;
        int x;
        this.originalImage = image;
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(this.width, this.height, this.originalImage.getType());
        this.imageMatrix = new int[this.width][this.height];
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                this.imageMatrix[x][y] = new Color(this.originalImage.getRGB(x, y)).getRed();
            }
        }
        this.mean = this.calculateMean();
        this.var = this.calculateVariance();
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                double normalizedPixel = 0.0;
                double squareError = 0.0;
                if (this.imageMatrix[x][y] > this.mean) {
                    squareError = (this.imageMatrix[x][y] - this.mean) * (this.imageMatrix[x][y] - this.mean);
                    normalizedPixel = this.targetMean + Math.sqrt(this.targetVariance * squareError / (double)this.var);
                } else {
                    squareError = (this.imageMatrix[x][y] - this.mean) * (this.imageMatrix[x][y] - this.mean);
                    normalizedPixel = this.targetMean - Math.sqrt(this.targetVariance * squareError / (double)this.var);
                }
                int alpha = new Color(this.originalImage.getRGB(x, y)).getAlpha();
                int rgb = (int)(-normalizedPixel);
                int color = ImageUtilities.argbToColor(alpha, rgb, rgb, rgb);
                this.filteredImage.setRGB(x, y, color);
            }
        }
        return this.filteredImage;
    }

    public int calculateVariance() {
        int var = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                var += (this.imageMatrix[x][y] - this.mean) * (this.imageMatrix[x][y] - this.mean);
            }
        }
        return var / (this.height * this.width * 255);
    }

    public int calculateMean() {
        double mean = 0.0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                mean += (double)this.imageMatrix[x][y];
            }
        }
        return (int)mean / (this.width * this.height);
    }

    public String toString() {
        return "Normalization Filter";
    }

    public void setTargetMean(double targetMean) {
        this.targetMean = targetMean;
    }

    public void setTargetVariance(double targetVariance) {
        this.targetVariance = targetVariance;
    }
}

