/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class ZhangSuenThinFilter
implements ImageFilter<BufferedImage> {
    private BufferedImage originalImage;
    private BufferedImage filteredImage;
    private boolean blackLetters = true;
    int[][] imageM;
    int width;
    int height;

    @Override
    public BufferedImage apply(BufferedImage image) {
        boolean same;
        int j;
        this.originalImage = image;
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(this.width, this.height, this.originalImage.getType());
        this.imageM = new int[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                int col = new Color(this.originalImage.getRGB(i, j)).getRed();
                this.imageM[i][j] = this.blackLetters ? 1 - col / 255 : col / 255;
            }
        }
        block2: do {
            int[][] start = new int[this.width][this.height];
            for (int i = 0; i < this.width; ++i) {
                for (int j2 = 0; j2 < this.height; ++j2) {
                    start[i][j2] = this.imageM[i][j2];
                }
            }
            this.thiningIteration(0);
            this.thiningIteration(1);
            same = true;
            for (int i = 0; i < this.width; ++i) {
                for (int j3 = 0; j3 < this.height; ++j3) {
                    if (start[i][j3] == this.imageM[i][j3]) continue;
                    same = false;
                    continue block2;
                }
            }
        } while (!same);
        for (int i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int col = this.blackLetters ? 255 - this.imageM[i][j] * 255 : this.imageM[i][j] * 255;
                int rgb = ImageUtilities.argbToColor(alpha, col, col, col);
                this.filteredImage.setRGB(i, j, rgb);
            }
        }
        return this.filteredImage;
    }

    public void thiningIteration(int iter) {
        int j;
        int i;
        int[][] marker = new int[this.width][this.height];
        for (i = 1; i < this.width - 1; ++i) {
            for (j = 1; j < this.height - 1; ++j) {
                int m2;
                int p2 = this.imageM[i - 1][j];
                int p3 = this.imageM[i - 1][j + 1];
                int p4 = this.imageM[i][j + 1];
                int p5 = this.imageM[i + 1][j + 1];
                int p6 = this.imageM[i + 1][j];
                int p7 = this.imageM[i + 1][j - 1];
                int p8 = this.imageM[i][j - 1];
                int p9 = this.imageM[i - 1][j - 1];
                int c1 = 0;
                int c2 = 0;
                int c3 = 0;
                int c4 = 0;
                int c5 = 0;
                int c6 = 0;
                int c7 = 0;
                int c8 = 0;
                if (p2 == 0 && p3 == 1) {
                    c1 = 1;
                }
                if (p3 == 0 && p4 == 1) {
                    c2 = 1;
                }
                if (p4 == 0 && p5 == 1) {
                    c3 = 1;
                }
                if (p5 == 0 && p6 == 1) {
                    c4 = 1;
                }
                if (p6 == 0 && p7 == 1) {
                    c5 = 1;
                }
                if (p7 == 0 && p8 == 1) {
                    c6 = 1;
                }
                if (p8 == 0 && p9 == 1) {
                    c7 = 1;
                }
                if (p9 == 0 && p2 == 1) {
                    c8 = 1;
                }
                int A = c1 + c2 + c3 + c4 + c5 + c6 + c7 + c8;
                int B = p2 + p3 + p4 + p5 + p6 + p7 + p8 + p9;
                int m1 = iter == 0 ? p2 * p4 * p6 : p2 * p4 * p8;
                int n = m2 = iter == 0 ? p4 * p6 * p8 : p2 * p6 * p8;
                if (A != 1 || B < 2 || B > 6 || m1 != 0 || m2 != 0) continue;
                marker[i][j] = 1;
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                int tmp = 1 - marker[i][j];
                this.imageM[i][j] = this.imageM[i][j] == tmp && this.imageM[i][j] == 1 ? 1 : 0;
            }
        }
    }

    public String toString() {
        return "Zhang-Suen Thin Method";
    }

    public void setBlackLetters(boolean blackLetters) {
        this.blackLetters = blackLetters;
    }
}

