/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.image.Image;

public class ImageJ2SE
implements Image {
    private BufferedImage bufferedImage;

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    private ImageJ2SE() {
    }

    private ImageJ2SE(Integer width, Integer height, Integer imageType) {
        this.bufferedImage = new BufferedImage(width, height, this.checkImageType(imageType));
    }

    private ImageJ2SE(File imageFile) throws IOException {
        this.bufferedImage = ImageIO.read(imageFile);
    }

    private ImageJ2SE(String filePath) throws IOException {
        this.bufferedImage = ImageIO.read(new File(filePath));
    }

    private ImageJ2SE(URL imageUrl) throws IOException {
        this.bufferedImage = ImageIO.read(imageUrl);
    }

    public ImageJ2SE(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    @Override
    public int getPixel(int x, int y) {
        return this.bufferedImage.getRGB(x, y);
    }

    @Override
    public void setPixel(int x, int y, int color) {
        this.bufferedImage.setRGB(x, y, color);
    }

    @Override
    public int[] getPixels(int offset, int stride, int x, int y, int width, int height) {
        int[] pixels = new int[width * height];
        this.bufferedImage.getRGB(x, y, width, height, pixels, offset, stride);
        return pixels;
    }

    @Override
    public void setPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.bufferedImage.setRGB(x, y, width, height, pixels, offset, stride);
    }

    @Override
    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    @Override
    public Image resize(int width, int height) {
        BufferedImage resizedImage = ImageUtilities.resizeImage(this.bufferedImage, width, height);
        return new ImageJ2SE(resizedImage);
    }

    @Override
    public Image crop(int x1, int y1, int x2, int y2) {
        BufferedImage croppedImage = ImageUtilities.cropImage(this.bufferedImage, x1, y1, x2, y2);
        return new ImageJ2SE(croppedImage);
    }

    private int checkImageType(int imageType) throws IllegalArgumentException {
        if (imageType < 0 || imageType > 13) {
            throw new IllegalArgumentException("Illegal image type, image type: " + imageType);
        }
        return imageType;
    }

    @Override
    public int getType() {
        return this.bufferedImage.getType();
    }
}

