/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.image.Dimension;

public class CharExtractor {
    private int cropTopY = 0;
    private int cropBottomY = 0;
    private int cropLeftX = 0;
    private int cropRightX = 0;
    private BufferedImage imageWithChars = null;
    private boolean endOfImage;
    private boolean endOfRow;

    public CharExtractor(BufferedImage imageWithChars) {
        this.imageWithChars = imageWithChars;
    }

    public void setImageWithChars(BufferedImage imageWithChars) {
        this.imageWithChars = imageWithChars;
    }

    private boolean findCropTopY() {
        for (int y = this.cropBottomY; y < this.imageWithChars.getHeight(); ++y) {
            for (int x = this.cropLeftX; x < this.imageWithChars.getWidth(); ++x) {
                if (this.imageWithChars.getRGB(x, y) != -16777216) continue;
                this.cropTopY = y;
                return true;
            }
        }
        this.endOfImage = true;
        return false;
    }

    private boolean findCropBottomY() {
        for (int y = this.cropTopY + 1; y < this.imageWithChars.getHeight(); ++y) {
            int whitePixCounter = 0;
            for (int x = this.cropLeftX; x < this.imageWithChars.getWidth(); ++x) {
                if (this.imageWithChars.getRGB(x, y) != -1) continue;
                ++whitePixCounter;
            }
            if (whitePixCounter == this.imageWithChars.getWidth()) {
                this.cropBottomY = y;
                return true;
            }
            if (y != this.imageWithChars.getHeight() - 1) continue;
            this.cropBottomY = y;
            this.endOfImage = true;
            return true;
        }
        return false;
    }

    private boolean findCropLeftX() {
        int whitePixCounter = 0;
        for (int x = this.cropRightX; x < this.imageWithChars.getWidth(); ++x) {
            for (int y = this.cropTopY; y <= this.cropBottomY; ++y) {
                if (this.imageWithChars.getRGB(x, y) != -16777216) continue;
                this.cropLeftX = x;
                return true;
            }
            if (++whitePixCounter != 3) continue;
            whitePixCounter = 0;
        }
        this.endOfRow = true;
        return false;
    }

    private boolean findCropRightX() {
        for (int x = this.cropLeftX + 1; x < this.imageWithChars.getWidth(); ++x) {
            int whitePixCounter = 0;
            for (int y = this.cropTopY; y <= this.cropBottomY; ++y) {
                if (this.imageWithChars.getRGB(x, y) != -1) continue;
                ++whitePixCounter;
            }
            int heightPixels = this.cropBottomY - this.cropTopY;
            if (whitePixCounter == heightPixels + 1) {
                this.cropRightX = x;
                return true;
            }
            if (x != this.imageWithChars.getWidth() - 1) continue;
            this.cropRightX = x;
            this.endOfRow = true;
            return true;
        }
        return false;
    }

    public HashMap<String, BufferedImage> extractCharImagesToLearn(BufferedImage imageWithText, List<String> chars, Dimension dim) {
        this.imageWithChars = imageWithText;
        HashMap<String, BufferedImage> charImages = new HashMap<String, BufferedImage>();
        int i = 0;
        while (!this.endOfImage) {
            this.endOfRow = false;
            boolean foundTop = this.findCropTopY();
            boolean foundBottom = false;
            if (!foundTop || !(foundBottom = this.findCropBottomY())) continue;
            while (!this.endOfRow) {
                boolean foundLeft = false;
                boolean foundRight = false;
                foundLeft = this.findCropLeftX();
                if (!foundLeft || !(foundRight = this.findCropRightX())) continue;
                BufferedImage charImage = ImageUtilities.cropImage((BufferedImage)imageWithText, (int)this.cropLeftX, (int)this.cropTopY, (int)this.cropRightX, (int)this.cropBottomY);
                charImage = ImageUtilities.trimImage((BufferedImage)charImage);
                charImage = ImageUtilities.resizeImage((BufferedImage)charImage, (int)dim.getWidth(), (int)dim.getHeight());
                charImages.put(chars.get(i), charImage);
                ++i;
            }
            this.cropLeftX = 0;
            this.cropRightX = 0;
        }
        this.cropTopY = 0;
        this.cropBottomY = 0;
        this.endOfImage = false;
        return charImages;
    }

    public List<BufferedImage> extractCharImagesToRecognize() {
        ArrayList<BufferedImage> trimedImages = new ArrayList<BufferedImage>();
        int i = 0;
        while (!this.endOfImage) {
            this.endOfRow = false;
            boolean foundTop = this.findCropTopY();
            boolean foundBottom = false;
            if (!foundTop || !(foundBottom = this.findCropBottomY())) continue;
            while (!this.endOfRow) {
                boolean foundLeft = false;
                boolean foundRight = false;
                foundLeft = this.findCropLeftX();
                if (!foundLeft || !(foundRight = this.findCropRightX())) continue;
                BufferedImage image = ImageUtilities.trimImage((BufferedImage)ImageUtilities.cropImage((BufferedImage)this.imageWithChars, (int)this.cropLeftX, (int)this.cropTopY, (int)this.cropRightX, (int)this.cropBottomY));
                trimedImages.add(image);
                ++i;
            }
            this.cropLeftX = 0;
            this.cropRightX = 0;
        }
        this.cropTopY = 0;
        this.cropBottomY = 0;
        this.endOfImage = false;
        return trimedImages;
    }
}

