/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.imgrec.ImageRecognitionPlugin;
import org.neuroph.ocr.filter.OCRCropLetter;
import org.neuroph.ocr.filter.OCRExtractLetter;
import org.neuroph.ocr.properties.OCRProperties;
import org.neuroph.ocr.util.Letter;
import org.neuroph.ocr.util.OCRUtilities;
import org.neuroph.ocr.util.Text;
import org.neuroph.ocr.util.WordPosition;

public class OCRTextRecognition
extends OCRProperties {
    private String recognizedTextPath;
    private NeuralNetwork nnet;
    private ImageRecognitionPlugin plugin;
    private String text;
    private boolean[][] visited;

    public OCRTextRecognition(Letter letterInformation, Text textInformation) {
        super(letterInformation, textInformation);
    }

    public void setRecognizedTextPath(String recognizedTextPath) {
        this.recognizedTextPath = recognizedTextPath;
    }

    public void setNeuralNetwork(NeuralNetwork nnet) {
        this.nnet = nnet;
        this.plugin = (ImageRecognitionPlugin)nnet.getPlugin(ImageRecognitionPlugin.class);
    }

    public void setNetworkPath(String networkPath) {
        this.nnet = NeuralNetwork.createFromFile((String)networkPath);
        this.plugin = (ImageRecognitionPlugin)this.nnet.getPlugin(ImageRecognitionPlugin.class);
    }

    public void recognize() {
        int imageHeight = this.image.getHeight();
        int imageWidth = this.image.getWidth();
        this.visited = new boolean[imageHeight][imageWidth];
        this.text = "";
        for (int i = 0; i < this.textInformation.numberOfRows(); ++i) {
            String rowText = this.recognizeRow(i);
            if (rowText.isEmpty()) continue;
            this.text = this.text + rowText + "\n";
        }
        this.visited = null;
    }

    private String recognizeRow(int row) {
        String rowText = "";
        List<WordPosition> words = this.textInformation.getWordsAtRow(row);
        for (int i = 0; i < words.size(); ++i) {
            int rowPixel = this.textInformation.getRowAt(row);
            WordPosition word = words.get(i);
            rowText = rowText + this.recognizeWord(word, rowPixel);
            if (i + 1 == words.size()) {
                rowText = rowText + this.addSpaces(word, null);
                continue;
            }
            WordPosition next = words.get(i + 1);
            rowText = rowText + this.addSpaces(word, next);
        }
        return rowText;
    }

    private String recognizeWord(WordPosition word, int rowPixel) {
        String wordText = "";
        int tmpWidth = 3 * this.letterInformation.getCropWidth();
        int tmpHeight = 3 * this.letterInformation.getCropHeight();
        int trashsize = this.letterInformation.getTrashSize();
        OCRExtractLetter extractionLetter = new OCRExtractLetter(tmpWidth, tmpHeight, trashsize);
        int letterSize = this.letterInformation.getLetterSize();
        int start = word.getStartPixel();
        int end = word.getEndPixel();
        Color white = Color.WHITE;
        for (int j = start; j < end; ++j) {
            for (int k = -(letterSize / 4); k < letterSize / 4; ++k) {
                BufferedImage letter;
                int i = rowPixel + k;
                if (i < 0 || i > this.image.getHeight()) continue;
                Color color = new Color(this.image.getRGB(j, i));
                if (color.equals(white)) {
                    this.visited[i][j] = true;
                    continue;
                }
                if (this.visited[i][j] || (letter = extractionLetter.extraxtLetter(this.image, this.visited, i, j)) == null) continue;
                OCRCropLetter crop = new OCRCropLetter(letter, this.letterInformation.getCropWidth(), this.letterInformation.getCropHeight());
                BufferedImage croped = crop.processImage();
                wordText = wordText + this.recognizeLetter(croped);
            }
        }
        return wordText;
    }

    private String recognizeLetter(BufferedImage image) {
        HashMap output = this.plugin.recognizeImage(image);
        return OCRUtilities.getCharacter(output);
    }

    private String addSpaces(WordPosition first, WordPosition second) {
        if (second == null) {
            return "";
        }
        String space = "";
        int gap = second.getStartPixel() - first.getEndPixel();
        int num = gap / this.letterInformation.getSpaceGap();
        for (int i = 0; i < num; ++i) {
            space = space + " ";
        }
        return space;
    }

    public String getRecognizedText() {
        return this.text;
    }

    public void saveText() {
        try {
            File file = new File(this.recognizedTextPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            String[] lines = this.text.split("\n");
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            for (String line : lines) {
                bw.write(line);
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

