/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.imgrec.ColorMode;
import org.neuroph.imgrec.FractionRgbData;
import org.neuroph.imgrec.ImageRecognitionHelper;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.image.Dimension;
import org.neuroph.imgrec.image.Image;
import org.neuroph.imgrec.image.ImageJ2SE;
import org.neuroph.ocr.CharExtractor;
import org.neuroph.ocr.OcrPlugin;
import org.neuroph.util.TransferFunctionType;
import org.neuroph.util.plugins.PluginBase;

public class OcrHelper
extends ImageRecognitionHelper {
    public static NeuralNetwork createNewNeuralNetwork(String label, Dimension samplingResolution, ColorMode colorMode, List<String> characterLabels, List<Integer> layersNeuronsCount, TransferFunctionType transferFunctionType) {
        NeuralNetwork neuralNetwork = ImageRecognitionHelper.createNewNeuralNetwork((String)label, (Dimension)samplingResolution, (ColorMode)colorMode, characterLabels, layersNeuronsCount, (TransferFunctionType)transferFunctionType);
        neuralNetwork.addPlugin((PluginBase)new OcrPlugin(samplingResolution, colorMode));
        return neuralNetwork;
    }

    public static DataSet createTrainingSet(String trainingSetName, BufferedImage imageWithChars, String chars, Dimension scaleToDim, List<String> imageLabels) {
        List<String> charList = Arrays.asList(chars.split(" "));
        CharExtractor charExtractor = new CharExtractor(imageWithChars);
        HashMap<String, BufferedImage> charImageMap = charExtractor.extractCharImagesToLearn(imageWithChars, charList, scaleToDim);
        for (String imgName : charImageMap.keySet()) {
            StringTokenizer st = new StringTokenizer(imgName, "._");
            String imgLabel = st.nextToken();
            if (imageLabels.contains(imgLabel)) continue;
            imageLabels.add(imgLabel);
        }
        Collections.sort(imageLabels);
        Map imageRgbData = ImageUtilities.getFractionRgbDataForImages(charImageMap);
        BufferedImage allWhite = new BufferedImage(scaleToDim.getWidth(), scaleToDim.getHeight(), 1);
        Graphics g = allWhite.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, allWhite.getWidth(), allWhite.getHeight());
        imageRgbData.put("allWhite", new FractionRgbData(allWhite));
        DataSet dataSet = ImageRecognitionHelper.createBlackAndWhiteTrainingSet(imageLabels, (Map)imageRgbData);
        dataSet.setLabel(trainingSetName);
        return dataSet;
    }

    public static List<Character> recognizeText(NeuralNetwork neuralNet, BufferedImage image, Dimension charDimension) {
        CharExtractor charExtractor = new CharExtractor(image);
        List<BufferedImage> charImages = charExtractor.extractCharImagesToRecognize();
        List<Character> characters = OcrHelper.recognize(neuralNet, charImages, charDimension);
        return characters;
    }

    public static List<Character> recognize(NeuralNetwork nnet, List<BufferedImage> images, Dimension charDimension) {
        OcrPlugin ocrPlugin = (OcrPlugin)nnet.getPlugin(OcrPlugin.class);
        ArrayList<Character> letters = new ArrayList<Character>();
        for (BufferedImage img : images) {
            Character letter = ocrPlugin.recognizeCharacter((Image)new ImageJ2SE(img), charDimension);
            letters.add(letter);
        }
        return letters;
    }
}

