/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.neuroph.imgrec.ColorMode;
import org.neuroph.imgrec.ImageRecognitionPlugin;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.image.Dimension;
import org.neuroph.imgrec.image.Image;
import org.neuroph.util.plugins.PluginBase;

public class OcrPlugin
extends PluginBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OCR_PLUGIN_NAME = "OCR Plugin";
    private Dimension samplingResolution;
    private ColorMode colorMode;

    public OcrPlugin(Dimension samplingResolution, ColorMode colorMode) {
        super(OCR_PLUGIN_NAME);
        this.samplingResolution = samplingResolution;
        this.colorMode = colorMode;
    }

    public Character recognizeCharacter(Image charImage, Dimension scaleToDim) {
        Image resizedImage = this.resizeImage(charImage, scaleToDim.getWidth(), scaleToDim.getHeight());
        return this.recognizeCharacter(resizedImage);
    }

    public Character recognizeCharacter(Image charImage) {
        ImageRecognitionPlugin imageRecognition = (ImageRecognitionPlugin)this.getParentNetwork().getPlugin(ImageRecognitionPlugin.class);
        HashMap output = imageRecognition.recognizeImage(charImage);
        HashMap n = imageRecognition.getMaxOutput();
        String ch = n.toString().substring(1, 2);
        return Character.valueOf(ch.charAt(0));
    }

    public HashMap recognizeCharacterProbabilities(Image charImage) {
        ImageRecognitionPlugin imageRecognition = (ImageRecognitionPlugin)this.getParentNetwork().getPlugin(ImageRecognitionPlugin.class);
        HashMap output = imageRecognition.recognizeImage(charImage);
        LinkedHashMap recognized = this.sortHashMapByValues(output);
        return recognized;
    }

    private Image resizeImage(Image image, int width, int height) {
        return ImageUtilities.resizeImage((Image)image, (int)width, (int)height);
    }

    private LinkedHashMap sortHashMapByValues(HashMap passedMap) {
        ArrayList mapKeys = new ArrayList(passedMap.keySet());
        ArrayList mapValues = new ArrayList(passedMap.values());
        Collections.sort(mapValues);
        Collections.sort(mapKeys);
        Collections.reverse(mapValues);
        LinkedHashMap<Character, Double> sortedMap = new LinkedHashMap<Character, Double>();
        block0: for (Object val : mapValues) {
            for (Object key : mapKeys) {
                String comp2;
                String comp1 = passedMap.get(key).toString();
                if (!comp1.equals(comp2 = val.toString())) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                Character charKey = Character.valueOf(key.toString().charAt(0));
                sortedMap.put(charKey, (Double)val);
                continue block0;
            }
        }
        return sortedMap;
    }

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public Dimension getSamplingResolution() {
        return this.samplingResolution;
    }
}

