/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.neuroph.imgrec.FractionRgbData;
import org.neuroph.imgrec.image.Image;
import org.neuroph.imgrec.image.ImageFactory;

public class OcrUtils {
    public static Image blackAndWhiteCleaning(Image image) {
        for (int j = 0; j < image.getHeight(); ++j) {
            for (int i = 0; i < image.getWidth(); ++i) {
                if (image.getPixel(i, j) == -16777216) continue;
                image.setPixel(i, j, -1);
            }
        }
        return image;
    }

    public static Image blackAndGrayCleaning(Image image) {
        for (int j = 0; j < image.getHeight(); ++j) {
            for (int i = 0; i < image.getWidth(); ++i) {
                if (image.getPixel(i, j) > -4473925) {
                    image.setPixel(i, j, -1);
                    continue;
                }
                image.setPixel(i, j, -16777216);
            }
        }
        return image;
    }

    public static Image blackAndLightGrayCleaning(Image image) {
        for (int j = 0; j < image.getHeight(); ++j) {
            for (int i = 0; i < image.getWidth(); ++i) {
                if (image.getPixel(i, j) > -4473925) {
                    image.setPixel(i, j, -1);
                    continue;
                }
                image.setPixel(i, j, -16777216);
            }
        }
        return image;
    }

    public static Image colorCleaning(Image image, int RGBcolor) {
        for (int j = 0; j < image.getHeight(); ++j) {
            for (int i = 0; i < image.getWidth(); ++i) {
                if (image.getPixel(i, j) == RGBcolor) {
                    image.setPixel(i, j, -16777216);
                    continue;
                }
                image.setPixel(i, j, -1);
            }
        }
        return image;
    }

    public static Image loadAndCleanImage(File f) {
        Image image = ImageFactory.getImage((File)f);
        return OcrUtils.blackAndLightGrayCleaning(image);
    }

    public static Image loadImage(File file) {
        Image image = ImageFactory.getImage((File)file);
        return image;
    }

    private static int trimLockup(Image img) {
        for (int j = 0; j < img.getHeight(); ++j) {
            for (int i = 0; i < img.getWidth(); ++i) {
                if (img.getPixel(i, j) != -16777216) continue;
                return j;
            }
        }
        return 0;
    }

    private static int trimLockdown(Image img, int y1) {
        for (int j = y1 + 1; j < img.getHeight(); ++j) {
            int counterWhite = 0;
            for (int i = 0; i < img.getWidth(); ++i) {
                if (img.getPixel(i, j) != -1) continue;
                ++counterWhite;
            }
            if (counterWhite == img.getWidth() && j > img.getHeight() / 2) {
                return j;
            }
            if (j != img.getHeight() - 1) continue;
            return j + 1;
        }
        return 0;
    }

    public static Map<String, FractionRgbData> getFractionRgbDataForImages(HashMap<String, Image> imagesData) {
        HashMap<String, FractionRgbData> rgbDataMap = new HashMap<String, FractionRgbData>();
        for (String character : imagesData.keySet()) {
            StringTokenizer st = new StringTokenizer(character, ".");
            Image image = imagesData.get(character);
            rgbDataMap.put(st.nextToken(), new FractionRgbData(image));
        }
        return rgbDataMap;
    }
}

