/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr.util.histogram;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class ImageHistogram {
    public static final int BLACK = 0;

    public static int[] histogramByHeight(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        int[] histogram = new int[height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int color = new Color(image.getRGB(x, y)).getRed();
                if (color != 0) continue;
                int n = y;
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public static int[] histogramByWidth(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        int[] histogram = new int[width];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = new Color(image.getRGB(x, y)).getRed();
                if (color != 0) continue;
                int n = x;
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public static int[] gradient(int[] histogram) {
        int[] gradient = new int[histogram.length];
        for (int i = 1; i < gradient.length; ++i) {
            gradient[i] = histogram[i] - histogram[i - 1];
        }
        return gradient;
    }
}

