/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.console;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleExecuteCommandEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.input.mapping.DefaultInputMapping;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConsoleDemoStartScreen
implements ScreenController,
KeyInputHandler,
NiftyExample {
    private Nifty nifty;
    private Screen screen;
    @Nullable
    private Element consolePopup;
    private boolean consoleVisible = false;
    private boolean allowConsoleToggle = true;
    private boolean firstConsoleShow = true;

    public void bind(@Nonnull Nifty newNifty, @Nonnull Screen newScreen) {
        this.nifty = newNifty;
        this.screen = newScreen;
        this.screen.addKeyboardInputHandler((NiftyInputMapping)new DefaultInputMapping(), (KeyInputHandler)this);
        this.consolePopup = this.nifty.createPopup("consolePopup");
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    public void back() {
        this.nifty.fromXml("all/intro.xml", "menu");
    }

    public boolean keyEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyStandardInputEvent.ConsoleToggle) {
            this.toggleConsole();
            return true;
        }
        return false;
    }

    private void toggleConsole() {
        if (this.allowConsoleToggle) {
            this.allowConsoleToggle = false;
            if (this.consoleVisible) {
                this.closeConsole();
            } else {
                this.openConsole();
            }
        }
    }

    private void openConsole() {
        String id;
        String string = id = this.consolePopup != null ? this.consolePopup.getId() : null;
        if (id == null) {
            return;
        }
        this.nifty.showPopup(this.screen, id, this.consolePopup.findElementById("console#textInput"));
        this.screen.processAddAndRemoveLayerElements();
        if (this.firstConsoleShow) {
            this.firstConsoleShow = false;
            Console console = (Console)this.screen.findNiftyControl("console", Console.class);
            if (console != null) {
                console.output("Nifty Console Demo\nVersion: 2.0");
            }
        }
        this.consoleVisible = true;
        this.allowConsoleToggle = true;
    }

    private void closeConsole() {
        String id;
        String string = id = this.consolePopup != null ? this.consolePopup.getId() : null;
        if (id == null) {
            return;
        }
        this.nifty.closePopup(id, new EndNotify(){

            public void perform() {
                ConsoleDemoStartScreen.this.consoleVisible = false;
                ConsoleDemoStartScreen.this.allowConsoleToggle = true;
            }
        });
    }

    @NiftyEventSubscriber(id="console")
    public void onConsoleCommand(String id, @Nonnull ConsoleExecuteCommandEvent command) {
        Console console = (Console)this.screen.findNiftyControl("console", Console.class);
        if (console != null) {
            console.output("your input was: " + command.getCommandLine() + " [" + command.getArgumentCount() + " parameter(s)]");
        }
        if ("exit".equals(command.getCommand())) {
            this.back();
        }
    }

    @Override
    @Nonnull
    public String getStartScreen() {
        return "start";
    }

    @Override
    @Nonnull
    public String getMainXML() {
        return "console/console.xml";
    }

    @Override
    @Nonnull
    public String getTitle() {
        return "Nifty Console Demonstation";
    }

    @Override
    public void prepareStart(Nifty nifty) {
    }
}

