/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.dragndrop;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.builder.ImageBuilder;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.DroppableDroppedEvent;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.dragndrop.builder.DraggableBuilder;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DragAndDropDialogController
implements Controller {
    private Nifty nifty;
    private Screen screen;
    @Nullable
    private Button resetButton;
    @Nullable
    private Element chestOpenElement;
    @Nullable
    private Label dragAndDropDescription;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.nifty = nifty;
        this.screen = screen;
        this.resetButton = (Button)screen.findNiftyControl("resetButton", Button.class);
        this.chestOpenElement = screen.findElementById("chest-open");
        this.dragAndDropDescription = (Label)screen.findNiftyControl("dragAndDropDescription", Label.class);
        this.resetButton.disable();
    }

    public void init(@Nonnull Parameters parameter) {
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(id="chest")
    public void onDrop(String id, @Nonnull DroppableDroppedEvent event) {
        if ("key".equals(event.getDraggable().getId())) {
            event.getDraggable().getElement().markForRemoval();
            this.chestOpenElement.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    DragAndDropDialogController.this.chestOpenElement.hide();
                    DragAndDropDialogController.this.dragAndDropDescription.setText("Well Done!");
                    DragAndDropDialogController.this.resetButton.enable();
                }
            }, "switchOpen");
        }
    }

    @NiftyEventSubscriber(id="resetButton")
    public void onResetButtonClicked(String id, ButtonClickedEvent event) {
        this.resetButton.disable();
        ((Label)this.screen.findNiftyControl("dragAndDropDescription", Label.class)).setText("Well Done!");
        this.dragAndDropDescription.setText("Drop the Key on the Chest to open it.");
        this.chestOpenElement.show();
        this.chestOpenElement.stopEffect(EffectEventId.onCustom);
        new DraggableBuilder("key"){
            {
                this.childLayoutCenter();
                this.image(new ImageBuilder(){
                    {
                        this.filename("defaultcontrols/dragndrop/Key.png");
                    }
                });
            }
        }.build(this.nifty, this.screen, this.screen.findElementById("key-initial#droppableContent"));
    }
}

