/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.listbox;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.TextFieldChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.examples.defaultcontrols.common.JustAnExampleModelClass;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListBoxDialogController
implements Controller {
    private Screen screen;
    @Nullable
    private ListBox<JustAnExampleModelClass> listBox;
    @Nullable
    private ListBox<JustAnExampleModelClass> selectionListBox;
    @Nullable
    private CheckBox multiSelectionCheckBox;
    @Nullable
    private CheckBox disableSelectionCheckBox;
    @Nullable
    private CheckBox forceSelectionCheckBox;
    @Nullable
    private Button appendButton;
    @Nullable
    private Button removeSelectionButton;
    @Nullable
    private TextField addTextField;
    @Nullable
    private Label selectedIndices;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.screen = screen;
        this.listBox = this.getListBox("listBox");
        this.selectionListBox = this.getListBox("selectionListBox");
        this.addTextField = (TextField)screen.findNiftyControl("addTextField", TextField.class);
        this.multiSelectionCheckBox = (CheckBox)screen.findNiftyControl("multiSelectionCheckBox", CheckBox.class);
        this.disableSelectionCheckBox = (CheckBox)screen.findNiftyControl("disableSelectionCheckBox", CheckBox.class);
        this.forceSelectionCheckBox = (CheckBox)screen.findNiftyControl("forceSelectionCheckBox", CheckBox.class);
        this.appendButton = (Button)screen.findNiftyControl("appendButton", Button.class);
        this.removeSelectionButton = (Button)screen.findNiftyControl("removeSelectionButton", Button.class);
        this.selectedIndices = (Label)screen.findNiftyControl("selectedIndices", Label.class);
        this.listBox.addItem((Object)new JustAnExampleModelClass("You can add more lines to this ListBox."));
        this.listBox.addItem((Object)new JustAnExampleModelClass("Use the append button to do this."));
        this.multiSelectionCheckBox.uncheck();
        this.disableSelectionCheckBox.uncheck();
        this.forceSelectionCheckBox.uncheck();
        this.addTextField.setText((CharSequence)"");
    }

    public void init(@Nonnull Parameters parameter) {
        this.updateSelectedIndexLabel(this.listBox.getSelectedIndices());
        this.setAppendButtonState();
        this.setRemoveSelectionButtonState();
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(pattern=".*CheckBox")
    public void onAllCheckBoxChanged(String id, CheckBoxStateChangedEvent event) {
        this.listBox.changeSelectionMode(this.getSelectionMode(), this.forceSelectionCheckBox.isChecked());
    }

    @NiftyEventSubscriber(id="listBox")
    public void onListBoxSelectionChanged(String id, @Nonnull ListBoxSelectionChangedEvent<JustAnExampleModelClass> changed) {
        this.selectionListBox.clear();
        this.selectionListBox.addAllItems((Collection)changed.getSelection());
        this.updateSelectedIndexLabel(changed.getSelectionIndices());
        this.setRemoveSelectionButtonState();
    }

    @NiftyEventSubscriber(id="addTextField")
    public void onAppendTextFieldChanged(String id, TextFieldChangedEvent event) {
        this.setAppendButtonState();
    }

    @NiftyEventSubscriber(id="addTextField")
    public void onAddTextFieldInputEvent(String id, NiftyStandardInputEvent event) {
        if (NiftyStandardInputEvent.SubmitText.equals((Object)event)) {
            this.appendButton.activate();
        }
    }

    @NiftyEventSubscriber(id="appendButton")
    public void onAppendButtonClicked(String id, ButtonClickedEvent event) {
        if (this.addTextField.getText().length() == 0) {
            return;
        }
        this.listBox.addItem((Object)new JustAnExampleModelClass(this.addTextField.getText()));
        this.listBox.showItemByIndex(this.listBox.itemCount() - 1);
    }

    @NiftyEventSubscriber(id="removeSelectionButton")
    public void onRemoveSelectionButtonClicked(String id, ButtonClickedEvent event) {
        if (!this.listBox.getSelection().isEmpty()) {
            this.listBox.removeAllItems((Collection)this.listBox.getSelection());
        }
    }

    @Nonnull
    private ListBox.SelectionMode getSelectionMode() {
        if (this.disableSelectionCheckBox.isChecked()) {
            return ListBox.SelectionMode.Disabled;
        }
        if (this.multiSelectionCheckBox.isChecked()) {
            return ListBox.SelectionMode.Multiple;
        }
        return ListBox.SelectionMode.Single;
    }

    private void setAppendButtonState() {
        if (this.addTextField.getText().isEmpty()) {
            this.appendButton.disable();
        } else {
            this.appendButton.enable();
        }
    }

    private void setRemoveSelectionButtonState() {
        if (this.selectionListBox.itemCount() == 0) {
            this.removeSelectionButton.disable();
        } else {
            this.removeSelectionButton.enable();
        }
    }

    private void updateSelectedIndexLabel(@Nullable List<Integer> selectionIndices) {
        if (selectionIndices == null || selectionIndices.isEmpty()) {
            this.selectedIndices.setText("N/A");
            return;
        }
        StringBuilder text = new StringBuilder();
        boolean first = true;
        for (Integer i : selectionIndices) {
            if (first) {
                first = false;
                text.append(i);
                continue;
            }
            text.append(", ");
            text.append(i);
        }
        this.selectedIndices.setText(text.toString());
    }

    @Nullable
    private ListBox<JustAnExampleModelClass> getListBox(String name) {
        return (ListBox)this.screen.findNiftyControl(name, ListBox.class);
    }
}

