/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.textfield;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.TextFieldChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TextFieldDialogController
implements Controller {
    @Nullable
    private TextField mainTextField;
    @Nullable
    private CheckBox passwordCharCheckBox;
    @Nullable
    private TextField passwordCharTextField;
    @Nullable
    private CheckBox maxLengthEnableCheckBox;
    @Nullable
    private TextField maxLengthTextField;
    @Nullable
    private Label textChangedLabel;
    @Nullable
    private Label keyEventLabel;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.mainTextField = (TextField)screen.findNiftyControl("mainTextField", TextField.class);
        this.passwordCharCheckBox = (CheckBox)screen.findNiftyControl("passwordCharCheckBox", CheckBox.class);
        this.passwordCharTextField = (TextField)screen.findNiftyControl("passwordCharTextField", TextField.class);
        this.maxLengthEnableCheckBox = (CheckBox)screen.findNiftyControl("maxLengthEnableCheckBox", CheckBox.class);
        this.maxLengthTextField = (TextField)screen.findNiftyControl("maxLengthTextField", TextField.class);
        this.textChangedLabel = (Label)screen.findNiftyControl("textChangedLabel", Label.class);
        this.keyEventLabel = (Label)screen.findNiftyControl("keyEventLabel", Label.class);
    }

    public void init(@Nonnull Parameters parameter) {
        this.passwordCharTextField.setText((CharSequence)"*");
        this.maxLengthTextField.setText((CharSequence)"5");
        this.textChangedLabel.setText("---");
        this.keyEventLabel.setText("---");
        this.keyEventLabel.setColor(new Color("#ff0f"));
        this.setPasswordCharTextFieldEnableState();
        this.setMaxLengthFieldEnableState();
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(id="passwordCharCheckBox")
    public void onPasswordCharCheckBoxChanged(String id, CheckBoxStateChangedEvent event) {
        this.setPasswordCharTextFieldEnableState();
    }

    @NiftyEventSubscriber(id="maxLengthEnableCheckBox")
    public void onMaxLengthEnableCheckBoxChanged(String id, CheckBoxStateChangedEvent event) {
        this.setMaxLengthFieldEnableState();
    }

    @NiftyEventSubscriber(id="passwordCharTextField")
    public void onPasswordCharTextFieldChanged(String id, TextFieldChangedEvent event) {
        this.updatePasswordChar();
    }

    @NiftyEventSubscriber(id="mainTextField")
    public void onTextChanged(String id, @Nonnull TextFieldChangedEvent event) {
        this.textChangedLabel.setText(event.getText());
    }

    @NiftyEventSubscriber(id="maxLengthTextField")
    public void onMaxLengthTextChanged(String id, @Nonnull TextFieldChangedEvent event) {
        this.setMaxLength(event.getText());
    }

    private void setMaxLength(String text) {
        try {
            this.mainTextField.setMaxLength(Integer.valueOf(text).intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NiftyEventSubscriber(id="mainTextField")
    public void onTextChanged(String id, @Nonnull NiftyStandardInputEvent event) {
        this.keyEventLabel.setText(event.toString() + " [" + event.getCharacter() + "]");
    }

    private void setPasswordCharTextFieldEnableState() {
        this.passwordCharTextField.setEnabled(this.passwordCharCheckBox.isChecked());
        this.updatePasswordChar();
    }

    private void updatePasswordChar() {
        if (this.passwordCharCheckBox.isChecked()) {
            if (this.passwordCharTextField.getText().isEmpty()) {
                this.mainTextField.disablePasswordChar();
            } else {
                this.mainTextField.enablePasswordChar(this.passwordCharTextField.getText().charAt(0));
            }
        } else {
            this.mainTextField.disablePasswordChar();
        }
    }

    private void setMaxLengthFieldEnableState() {
        this.maxLengthTextField.setEnabled(this.maxLengthEnableCheckBox.isChecked());
        if (this.maxLengthEnableCheckBox.isChecked()) {
            this.setMaxLength(this.maxLengthTextField.getText());
        } else {
            this.mainTextField.setMaxLength(-1);
        }
    }
}

