/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.table;

import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.PanelRenderer;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.examples.table.TableRow;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.Color;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

class TableRowViewConverter
implements ListBox.ListBoxViewConverter<TableRow> {
    private static final Logger log = Logger.getLogger(TableRowViewConverter.class.getName());

    TableRowViewConverter() {
    }

    public void display(@Nonnull Element listBoxItem, @Nonnull TableRow item) {
        for (int i = 0; i < 5; ++i) {
            String textElementId;
            Element textElement;
            Color color = new Color("#ff05");
            if (item.index % 2 == 0) {
                color = new Color("#00f5");
            }
            if ((textElement = listBoxItem.findElementById(textElementId = "#col-" + i)) == null) {
                log.warning("Failed to locate display area of table. Looking for: " + textElementId);
            } else {
                TextRenderer textRenderer = (TextRenderer)textElement.getRenderer(TextRenderer.class);
                if (textRenderer == null) {
                    log.warning("Text element does not contain a text renderer.");
                } else {
                    textRenderer.setText(item.data[i]);
                }
            }
            PanelRenderer panelRenderer = (PanelRenderer)listBoxItem.getRenderer(PanelRenderer.class);
            if (panelRenderer == null) {
                log.warning("Background element does not contain a panel renderer.");
                continue;
            }
            panelRenderer.setBackgroundColor(color);
        }
    }

    public int getWidth(@Nonnull Element listBoxItem, @Nonnull TableRow item) {
        int width = 0;
        for (int i = 0; i < 5; ++i) {
            String textElementId = "#col-" + i;
            Element textElement = listBoxItem.findElementById(textElementId);
            if (textElement == null) {
                log.warning("Failed to locate display area of table. Looking for: " + textElementId);
                continue;
            }
            TextRenderer textRenderer = (TextRenderer)textElement.getRenderer(TextRenderer.class);
            if (textRenderer == null) {
                log.warning("Text element does not contain a text renderer.");
                continue;
            }
            RenderFont font = textRenderer.getFont();
            if (font == null) {
                log.warning("Text render does not have a font assigned.");
                continue;
            }
            width += font.getWidth(item.data[i]);
        }
        return width;
    }
}

