/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 *
 * Copyright 2003 The Nimbus Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Map;
import java.util.List;

import jp.ossc.nimbus.core.ServiceName;


/**
 * {@link HttpServletRequestTransferInterceptorService}のMBeanインタフェース。
 * <p>
 *
 * @author M.Ishida
 * @see HttpServletRequestTransferInterceptorService
 */
public interface HttpServletRequestTransferInterceptorServiceMBean extends ServletFilterInterceptorServiceMBean {

    /**
     * ThreadContextサービスのサービス名を設定する。<p>
     *
     * @param name ThreadContextサービスのサービス名
     */
    public void setThreadContextServiceName(ServiceName name);

    /**
     * ThreadContextサービスのサービス名を取得する。<p>
     *
     * @return ThreadContextサービスのサービス名
     */
    public ServiceName getThreadContextServiceName();

    /**
     * HttpServletRequestオブジェクトのプロパティ名とThreadContextに設定するキー名のマッピングを設定する。<p>
     *
     * @param mapping マッピング
     */
    public void setRequestPropertyAndContextKeyMapping(Map mapping);
    
    /**
     * ThreadContextサービスのコードマスタのキー名を設定する。<p>
     * デフォルトは、{@link jp.ossc.nimbus.service.aop.interceptor.ThreadContextKey#CODEMASTER}。<br>
     *
     * @param key コードマスタのキー名
     */
    public void setCodeMasterContextKey(String key);
    
    /**
     * ThreadContextサービスのコードマスタのキー名を取得する。<p>
     *
     * @return コードマスタのキー名
     */
    public String getCodeMasterContextKey();
    
    /**
     * 移し替え設定を設定する。<p>
     *
     * @param setting 移し替え設定
     */
    public void setTransferSetting(HttpServletRequestTransferInterceptorService.TransferSetting setting);
    
    /**
     * 移し替え設定を削除する。<p>
     */
    public void clearTransferSettings();
    
    /**
     * 移し替え設定のリストを取得する。<p>
     *
     * @return 移し替え設定のリスト
     */
    public List getTransferSettings();
}