/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The Nimbus Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.service.journal.editor;

/**
 * {@link BlockJournalEditorServiceBase}のMBeanインタフェース。<p>
 * 
 * @author M.Takata
 * @see BlockJournalEditorServiceBase
 */
public interface BlockJournalEditorServiceBaseMBean
 extends ImmutableJournalEditorServiceBaseMBean{
    
    /**
     * ヘッダー文字列を設定する。<p>
     *
     * @param header ヘッダー文字列
     * @see #getHeader()
     */
    public void setHeader(String header);
    
    /**
     * ヘッダー文字列を取得する。<p>
     *
     * @return ヘッダー文字列
     * @see #setHeader(String)
     */
    public String getHeader();
    
    /**
     * ヘッダー文字列を出力するかどうかを設定する。<p>
     *
     * @param isOutput trueの場合、ヘッダー文字列を出力する
     */
    public void setOutputHeader(boolean isOutput);
    
    /**
     * ヘッダー文字列を出力するかどうかを判定する。<p>
     *
     * @return trueの場合、ヘッダー文字列を出力する
     */
    public boolean isOutputHeader();
    
    /**
     * ブロックの開始及び終了で改行を出力するかどうかを設定する。<p>
     * デフォルトはtrueで、出力する。<p>
     *
     * @param isOutput 改行を出力する場合はtrue
     */
    public void setOutputBlockLineSeparator(boolean isOutput);
    
    /**
     * ブロックの開始及び終了で改行を出力するかどうかを判定する。<p>
     *
     * @return trueの場合、改行を出力する
     */
    public boolean isOutputBlockLineSeparator();
    
    /**
     * ブロック開始セパレータ文字列を設定する。<p>
     *
     * @param start ブロック開始セパレータ文字列
     * @see #getStartBlockSeparator()
     */
    public void setStartBlockSeparator(String start);
    
    /**
     * ブロック開始セパレータ文字列を取得する。<p>
     *
     * @return ブロック開始セパレータ文字列
     * @see #setStartBlockSeparator(String)
     */
    public String getStartBlockSeparator();
    
    /**
     * ブロック終了セパレータ文字列を設定する。<p>
     *
     * @param end ブロック終了セパレータ文字列
     * @see #getEndBlockSeparator()
     */
    public void setEndBlockSeparator(String end);
    
    /**
     * ブロック終了セパレータ文字列を取得する。<p>
     *
     * @return ブロック終了セパレータ文字列
     * @see #setEndBlockSeparator(String)
     */
    public String getEndBlockSeparator();
}
