/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The Nimbus Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.servlet;


import javax.servlet.http.HttpServletRequest;

/* **Version Difference Comment Start**
import jakarta.servlet.http.HttpServletRequest;
**Version Difference Comment End** */

import jp.ossc.nimbus.core.ServiceBase;

/**
 * BeanFlowのフロー名をリクエストパスから選択する。<p>
 *
 * @author M.Takata
 */
public class DefaultBeanFlowSelectorService extends ServiceBase
 implements BeanFlowSelector, DefaultBeanFlowSelectorServiceMBean{
    
    private static final long serialVersionUID = 7550507018580655170L;
    
    /**
     * アクションBeanFlowの後置詞。<p>
     * デフォルトは、{@link #DEFAULT_BEAN_FLOW_PATH_POSTFIX}。<br>
     */
    protected String beanFlowPathPostfix = DEFAULT_BEAN_FLOW_PATH_POSTFIX;
    
    public void setBeanFlowPathPostfix(String postfix){
        beanFlowPathPostfix = postfix;
    }
    
    public String getBeanFlowPathPostfix(){
        return beanFlowPathPostfix;
    }
    
    /**
     * BeanFlowのフロー名を選択する。<p>
     *
     * @param req HTTPリクエスト
     * @return BeanFlowのフロー名
     */
    public String selectBeanFlow(HttpServletRequest req){
        
        String flowName = req.getServletPath();
        if(req.getPathInfo() != null){
            flowName = flowName + req.getPathInfo();
        }
        if(flowName == null || flowName.length() == 0){
            return null;
        }
        if(flowName.endsWith(beanFlowPathPostfix)){
            flowName = flowName.substring(
                0,
                flowName.length() - beanFlowPathPostfix.length()
            );
        }
        if(flowName.length() == 0){
            return null;
        }
        return flowName;
    }
}
