/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.Environment;
import android.os.SystemClock;
import github.nisrulz.easydeviceinfo.base.RingerMode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class EasyConfigMod {
    private final Context context;

    public EasyConfigMod(Context context) {
        this.context = context;
    }

    public final boolean hasSdCard() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public final boolean isRunningOnEmulator() {
        boolean isGenyMotion = Build.MANUFACTURER.contains("Genymotion") || Build.PRODUCT.contains("vbox86p") || Build.DEVICE.contains("vbox86p") || Build.HARDWARE.contains("vbox86");
        boolean isGenericEmulator = Build.BRAND.contains("generic") || Build.DEVICE.contains("generic") || Build.PRODUCT.contains("sdk") || Build.HARDWARE.contains("goldfish");
        return isGenericEmulator || isGenyMotion;
    }

    @RingerMode
    public final int getDeviceRingerMode() {
        int ringerMode = 1;
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        if (audioManager != null) {
            switch (audioManager.getRingerMode()) {
                case 2: {
                    ringerMode = 1;
                    break;
                }
                case 0: {
                    ringerMode = 0;
                    break;
                }
                case 1: {
                    ringerMode = 2;
                    break;
                }
            }
        }
        return ringerMode;
    }

    public final long getTime() {
        return System.currentTimeMillis();
    }

    public final String getFormattedTime() {
        DateFormat timeInstance = SimpleDateFormat.getTimeInstance();
        return timeInstance.format(Calendar.getInstance().getTime());
    }

    public final long getUpTime() {
        return SystemClock.uptimeMillis();
    }

    public final String getFormattedUpTime() {
        DateFormat timeInstance = SimpleDateFormat.getTimeInstance();
        return timeInstance.format(SystemClock.uptimeMillis());
    }

    public final Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    public final String getFormattedDate() {
        DateFormat dateInstance = SimpleDateFormat.getDateInstance();
        return dateInstance.format(Calendar.getInstance().getTime());
    }
}

