/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresPermission;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import github.nisrulz.easydeviceinfo.base.CheckValidityUtil;
import github.nisrulz.easydeviceinfo.base.DeviceType;
import github.nisrulz.easydeviceinfo.base.OrientationType;
import github.nisrulz.easydeviceinfo.base.PermissionUtil;
import github.nisrulz.easydeviceinfo.base.PhoneType;
import github.nisrulz.easydeviceinfo.common.EasyDeviceInfo;
import java.io.File;
import java.util.Locale;

public class EasyDeviceMod {
    private final TelephonyManager tm;
    private final Context context;

    public EasyDeviceMod(Context context) {
        this.context = context;
        this.tm = (TelephonyManager)context.getSystemService("phone");
    }

    @PhoneType
    public final int getPhoneType() {
        switch (this.tm.getPhoneType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public final String getPhoneNo() {
        String result = null;
        if (PermissionUtil.hasPermission(this.context, "android.permission.READ_PHONE_STATE") && this.tm.getLine1Number() != null) {
            result = this.tm.getLine1Number();
        }
        return CheckValidityUtil.checkValidData(result);
    }

    public final String getProduct() {
        return CheckValidityUtil.checkValidData(Build.PRODUCT);
    }

    public final String getFingerprint() {
        return CheckValidityUtil.checkValidData(Build.FINGERPRINT);
    }

    public final String getHardware() {
        return CheckValidityUtil.checkValidData(Build.HARDWARE);
    }

    public final String getRadioVer() {
        String result = null;
        if (Build.VERSION.SDK_INT >= 14) {
            result = Build.getRadioVersion();
        }
        return CheckValidityUtil.checkValidData(result);
    }

    public final String getDevice() {
        return CheckValidityUtil.checkValidData(Build.DEVICE);
    }

    public final String getBootloader() {
        return CheckValidityUtil.checkValidData(Build.BOOTLOADER);
    }

    public final String getBoard() {
        return CheckValidityUtil.checkValidData(Build.BOARD);
    }

    public final String getDisplayVersion() {
        return CheckValidityUtil.checkValidData(Build.DISPLAY);
    }

    public final String getLanguage() {
        return CheckValidityUtil.checkValidData(Locale.getDefault().getLanguage());
    }

    @DeviceType
    public final int getDeviceType(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        float yInches = (float)metrics.heightPixels / metrics.ydpi;
        float xInches = (float)metrics.widthPixels / metrics.xdpi;
        double diagonalInches = Math.sqrt(xInches * xInches + yInches * yInches);
        if (diagonalInches > 10.1) {
            return 4;
        }
        if (diagonalInches <= 10.1 && diagonalInches > 7.0) {
            return 3;
        }
        if (diagonalInches <= 7.0 && diagonalInches > 6.5) {
            return 2;
        }
        if (diagonalInches <= 6.5 && diagonalInches >= 2.0) {
            return 1;
        }
        return 0;
    }

    public final String getManufacturer() {
        return CheckValidityUtil.checkValidData(CheckValidityUtil.handleIllegalCharacterInResult(Build.MANUFACTURER));
    }

    public final String getModel() {
        return CheckValidityUtil.checkValidData(CheckValidityUtil.handleIllegalCharacterInResult(Build.MODEL));
    }

    public final String getBuildBrand() {
        return CheckValidityUtil.checkValidData(CheckValidityUtil.handleIllegalCharacterInResult(Build.BRAND));
    }

    public final String getBuildHost() {
        return CheckValidityUtil.checkValidData(Build.HOST);
    }

    public final String getBuildTags() {
        return CheckValidityUtil.checkValidData(Build.TAGS);
    }

    public final long getBuildTime() {
        return Build.TIME;
    }

    public final String getBuildUser() {
        return CheckValidityUtil.checkValidData(Build.USER);
    }

    public final String getBuildVersionRelease() {
        return CheckValidityUtil.checkValidData(Build.VERSION.RELEASE);
    }

    public final String getScreenDisplayID() {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        if (wm != null) {
            Display display = wm.getDefaultDisplay();
            return CheckValidityUtil.checkValidData(String.valueOf(display.getDisplayId()));
        }
        return CheckValidityUtil.checkValidData("");
    }

    public final String getBuildVersionCodename() {
        return CheckValidityUtil.checkValidData(Build.VERSION.CODENAME);
    }

    public final String getBuildVersionIncremental() {
        return CheckValidityUtil.checkValidData(Build.VERSION.INCREMENTAL);
    }

    public final int getBuildVersionSDK() {
        return Build.VERSION.SDK_INT;
    }

    public final String getBuildID() {
        return CheckValidityUtil.checkValidData(Build.ID);
    }

    public final boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public final String getIMEI() {
        String result = null;
        if (PermissionUtil.hasPermission(this.context, "android.permission.READ_PHONE_STATE")) {
            result = this.tm.getDeviceId();
        }
        return CheckValidityUtil.checkValidData(result);
    }

    @SuppressLint(value={"HardwareIds"})
    public final String getSerial() {
        String result = null;
        if (Build.VERSION.SDK_INT < 26) {
            result = Build.SERIAL;
        } else if (PermissionUtil.hasPermission(this.context, "android.permission.READ_PHONE_STATE")) {
            result = Build.getSerial();
        }
        return CheckValidityUtil.checkValidData(result);
    }

    public final String getOSCodename() {
        String codename;
        switch (Build.VERSION.SDK_INT) {
            case 1: {
                codename = "First Android Version. Yay !";
                break;
            }
            case 2: {
                codename = "Base Android 1.1";
                break;
            }
            case 3: {
                codename = "Cupcake";
                break;
            }
            case 4: {
                codename = "Donut";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                codename = "Eclair";
                break;
            }
            case 8: {
                codename = "Froyo";
                break;
            }
            case 9: 
            case 10: {
                codename = "Gingerbread";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                codename = "Honeycomb";
                break;
            }
            case 14: 
            case 15: {
                codename = "Ice Cream Sandwich";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                codename = "Jelly Bean";
                break;
            }
            case 19: {
                codename = "Kitkat";
                break;
            }
            case 20: {
                codename = "Kitkat Watch";
                break;
            }
            case 21: 
            case 22: {
                codename = "Lollipop";
                break;
            }
            case 23: {
                codename = "Marshmallow";
                break;
            }
            case 24: 
            case 25: {
                codename = "Nougat";
                break;
            }
            case 26: {
                codename = "O";
                break;
            }
            default: {
                codename = EasyDeviceInfo.notFoundVal;
            }
        }
        return codename;
    }

    public final String getOSVersion() {
        return CheckValidityUtil.checkValidData(Build.VERSION.RELEASE);
    }

    @OrientationType
    public final int getOrientation(Activity activity) {
        switch (activity.getResources().getConfiguration().orientation) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }
}

