/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import github.nisrulz.easydeviceinfo.base.CheckValidityUtil;
import github.nisrulz.easydeviceinfo.base.PermissionUtil;
import github.nisrulz.easydeviceinfo.common.EasyDeviceInfo;
import java.util.UUID;

public class EasyIdMod {
    private final Context context;

    public EasyIdMod(Context context) {
        this.context = context;
    }

    @Deprecated
    @SuppressLint(value={"HardwareIds"})
    public final String getAndroidID() {
        return CheckValidityUtil.checkValidData(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id"));
    }

    @Deprecated
    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public final String[] getAccounts() {
        String[] result = null;
        if (Build.VERSION.SDK_INT < 26 && PermissionUtil.hasPermission(this.context, "android.permission.GET_ACCOUNTS")) {
            Account[] accounts = AccountManager.get((Context)this.context).getAccountsByType("com.google");
            result = new String[accounts.length];
            for (int i = 0; i < accounts.length; ++i) {
                result[i] = accounts[i].name;
            }
        }
        return CheckValidityUtil.checkValidData(result);
    }

    public final String getUA() {
        String systemUa = System.getProperty("http.agent");
        String result = Build.VERSION.SDK_INT >= 17 ? WebSettings.getDefaultUserAgent((Context)this.context) + "__" + systemUa : new WebView(this.context).getSettings().getUserAgentString() + "__" + systemUa;
        return CheckValidityUtil.checkValidData(result);
    }

    public final String getPseudoUniqueID() {
        String devIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10;
        devIDShort = Build.VERSION.SDK_INT >= 21 ? devIDShort + Build.SUPPORTED_ABIS[0].length() % 10 : devIDShort + Build.CPU_ABI.length() % 10;
        devIDShort = devIDShort + (Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10);
        try {
            String serial = Build.class.getField("SERIAL").get(null).toString();
            return new UUID(devIDShort.hashCode(), serial.hashCode()).toString();
        }
        catch (Exception e) {
            if (EasyDeviceInfo.debuggable) {
                Log.e((String)"EasyDeviceInfo", (String)"getPseudoUniqueID: ", (Throwable)e);
            }
            String serial = "ESYDV000";
            return new UUID(devIDShort.hashCode(), serial.hashCode()).toString();
        }
    }

    @RequiresPermission(value="com.google.android.providers.gsf.permission.READ_GSERVICES")
    public final String getGSFID() {
        Uri uri = Uri.parse((String)"content://com.google.android.gsf.gservices");
        String idKey = "android_id";
        String[] params = new String[]{"android_id"};
        Cursor c = this.context.getContentResolver().query(uri, null, null, params, null);
        if (c == null) {
            return EasyDeviceInfo.notFoundVal;
        }
        if (!c.moveToFirst() || c.getColumnCount() < 2) {
            c.close();
            return EasyDeviceInfo.notFoundVal;
        }
        try {
            String gsfID = Long.toHexString(Long.parseLong(c.getString(1)));
            c.close();
            return gsfID;
        }
        catch (NumberFormatException e) {
            c.close();
            return EasyDeviceInfo.notFoundVal;
        }
    }
}

