/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.annotation.RequiresPermission;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import github.nisrulz.easydeviceinfo.base.CheckValidityUtil;
import github.nisrulz.easydeviceinfo.base.NetworkType;
import github.nisrulz.easydeviceinfo.base.PermissionUtil;
import github.nisrulz.easydeviceinfo.common.EasyDeviceInfo;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;

public class EasyNetworkMod {
    private static final String SOCKET_EXCEPTION = "Socket Exception";
    private final Context context;

    public EasyNetworkMod(Context context) {
        this.context = context;
    }

    public final boolean isWifiEnabled() {
        boolean wifiState = false;
        WifiManager wifiManager = (WifiManager)this.context.getApplicationContext().getSystemService("wifi");
        if (wifiManager != null) {
            wifiState = wifiManager.isWifiEnabled();
        }
        return wifiState;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_NETWORK_STATE", "android.permission.INTERNET"})
    public final boolean isNetworkAvailable() {
        ConnectivityManager cm;
        if (PermissionUtil.hasPermission(this.context, "android.permission.INTERNET") && PermissionUtil.hasPermission(this.context, "android.permission.ACCESS_NETWORK_STATE") && (cm = (ConnectivityManager)this.context.getApplicationContext().getSystemService("connectivity")) != null) {
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        return false;
    }

    public final String getIPv4Address() {
        String result;
        block4: {
            result = null;
            try {
                ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
                for (NetworkInterface intf : interfaces) {
                    ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                    for (InetAddress addr : addrs) {
                        if (addr.isLoopbackAddress()) continue;
                        String sAddr = addr.getHostAddress().toUpperCase(Locale.getDefault());
                        boolean isIPv4 = addr instanceof Inet4Address;
                        if (!isIPv4) continue;
                        result = sAddr;
                    }
                }
            }
            catch (SocketException e) {
                if (!EasyDeviceInfo.debuggable) break block4;
                Log.e((String)"EasyDeviceInfo", (String)SOCKET_EXCEPTION, (Throwable)e);
            }
        }
        return CheckValidityUtil.checkValidData(result);
    }

    public final String getIPv6Address() {
        String result;
        block4: {
            result = null;
            try {
                ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
                for (NetworkInterface intf : interfaces) {
                    ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                    for (InetAddress addr : addrs) {
                        if (addr.isLoopbackAddress()) continue;
                        String sAddr = addr.getHostAddress().toUpperCase(Locale.getDefault());
                        boolean isIPv4 = addr instanceof Inet4Address;
                        if (isIPv4) continue;
                        int delim = sAddr.indexOf(37);
                        result = delim < 0 ? sAddr : sAddr.substring(0, delim);
                    }
                }
            }
            catch (SocketException e) {
                if (!EasyDeviceInfo.debuggable) break block4;
                Log.e((String)"EasyDeviceInfo", (String)SOCKET_EXCEPTION, (Throwable)e);
            }
        }
        return CheckValidityUtil.checkValidData(result);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_NETWORK_STATE", "android.permission.INTERNET"})
    @NetworkType
    public final int getNetworkType() {
        ConnectivityManager cm;
        int result = 0;
        if (PermissionUtil.hasPermission(this.context, "android.permission.ACCESS_NETWORK_STATE") && (cm = (ConnectivityManager)this.context.getSystemService("connectivity")) != null) {
            TelephonyManager manager;
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (activeNetwork == null) {
                result = 0;
            } else if (activeNetwork.getType() == 1 || activeNetwork.getType() == 6) {
                result = 1;
            } else if (activeNetwork.getType() == 0 && (manager = (TelephonyManager)this.context.getSystemService("phone")) != null && manager.getSimState() == 5) {
                switch (manager.getNetworkType()) {
                    case 0: {
                        result = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        result = 3;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 15: {
                        result = 4;
                        break;
                    }
                    case 13: {
                        result = 5;
                        break;
                    }
                    default: {
                        result = 6;
                    }
                }
            }
        }
        return result;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public final String getWifiMAC() {
        String result = "02:00:00:00:00:00";
        if (PermissionUtil.hasPermission(this.context, "android.permission.ACCESS_WIFI_STATE")) {
            if (Build.VERSION.SDK_INT >= 23) {
                Enumeration<NetworkInterface> interfaces;
                block11: {
                    interfaces = null;
                    try {
                        interfaces = NetworkInterface.getNetworkInterfaces();
                    }
                    catch (SocketException e) {
                        if (!EasyDeviceInfo.debuggable) break block11;
                        Log.e((String)"EasyDeviceInfo", (String)SOCKET_EXCEPTION, (Throwable)e);
                    }
                }
                while (interfaces != null && interfaces.hasMoreElements()) {
                    byte[] addr;
                    NetworkInterface networkInterface;
                    block12: {
                        networkInterface = interfaces.nextElement();
                        addr = new byte[]{};
                        try {
                            addr = networkInterface.getHardwareAddress();
                        }
                        catch (SocketException e) {
                            if (!EasyDeviceInfo.debuggable) break block12;
                            Log.e((String)"EasyDeviceInfo", (String)SOCKET_EXCEPTION, (Throwable)e);
                        }
                    }
                    if (addr == null || addr.length == 0) continue;
                    StringBuilder buf = new StringBuilder();
                    for (byte b : addr) {
                        buf.append(String.format("%02X:", b));
                    }
                    if (buf.length() > 0) {
                        buf.deleteCharAt(buf.length() - 1);
                    }
                    String mac = buf.toString();
                    String wifiInterfaceName = "wlan0";
                    result = wifiInterfaceName.equals(networkInterface.getName()) ? mac : result;
                }
            } else {
                WifiManager wm = (WifiManager)this.context.getApplicationContext().getSystemService("wifi");
                if (wm != null) {
                    result = wm.getConnectionInfo().getMacAddress();
                }
            }
        }
        return CheckValidityUtil.checkValidData(result);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_NETWORK_STATE"})
    public final String getWifiSSID() {
        ConnectivityManager cm;
        String result = null;
        if (PermissionUtil.hasPermission(this.context, "android.permission.ACCESS_WIFI_STATE") && (cm = (ConnectivityManager)this.context.getSystemService("connectivity")) != null) {
            WifiInfo connectionInfo;
            WifiManager wifiManager;
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo == null) {
                result = null;
            }
            if (networkInfo != null && networkInfo.isConnected() && (wifiManager = (WifiManager)this.context.getApplicationContext().getSystemService("wifi")) != null && (connectionInfo = wifiManager.getConnectionInfo()) != null && !TextUtils.isEmpty((CharSequence)connectionInfo.getSSID())) {
                result = connectionInfo.getSSID();
            }
        }
        return CheckValidityUtil.checkValidData(result);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_NETWORK_STATE"})
    public final String getWifiBSSID() {
        ConnectivityManager cm;
        String result = null;
        if (PermissionUtil.hasPermission(this.context, "android.permission.ACCESS_WIFI_STATE") && (cm = (ConnectivityManager)this.context.getSystemService("connectivity")) != null) {
            WifiInfo connectionInfo;
            WifiManager wifiManager;
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo == null) {
                result = null;
            }
            if (networkInfo != null && networkInfo.isConnected() && (wifiManager = (WifiManager)this.context.getApplicationContext().getSystemService("wifi")) != null && (connectionInfo = wifiManager.getConnectionInfo()) != null && !TextUtils.isEmpty((CharSequence)connectionInfo.getSSID())) {
                result = connectionInfo.getBSSID();
            }
        }
        return CheckValidityUtil.checkValidData(result);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_NETWORK_STATE"})
    public final String getWifiLinkSpeed() {
        ConnectivityManager cm;
        String result = null;
        if (PermissionUtil.hasPermission(this.context, "android.permission.ACCESS_WIFI_STATE") && (cm = (ConnectivityManager)this.context.getSystemService("connectivity")) != null) {
            WifiInfo connectionInfo;
            WifiManager wifiManager;
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo == null) {
                result = null;
            }
            if (networkInfo != null && networkInfo.isConnected() && (wifiManager = (WifiManager)this.context.getApplicationContext().getSystemService("wifi")) != null && (connectionInfo = wifiManager.getConnectionInfo()) != null && !TextUtils.isEmpty((CharSequence)connectionInfo.getSSID())) {
                result = connectionInfo.getLinkSpeed() + " Mbps";
            }
        }
        return CheckValidityUtil.checkValidData(result);
    }

    public final boolean isWifiAwareAvailable() {
        return Build.VERSION.SDK_INT >= 26 && this.context.getPackageManager().hasSystemFeature("android.hardware.wifi.aware");
    }
}

