/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresPermission;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import github.nisrulz.easydeviceinfo.base.CheckValidityUtil;
import github.nisrulz.easydeviceinfo.base.PermissionUtil;
import github.nisrulz.easydeviceinfo.common.EasyDeviceInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class EasySimMod {
    private final TelephonyManager tm;
    private final Context context;

    public EasySimMod(Context context) {
        this.context = context;
        this.tm = (TelephonyManager)context.getSystemService("phone");
    }

    public final String getCountry() {
        String result;
        if (this.tm != null && this.tm.getSimState() == 5) {
            result = this.tm.getSimCountryIso().toLowerCase(Locale.getDefault());
        } else {
            Locale locale = Locale.getDefault();
            result = locale.getCountry().toLowerCase(locale);
        }
        return CheckValidityUtil.checkValidData(CheckValidityUtil.handleIllegalCharacterInResult(result));
    }

    public final boolean isSimNetworkLocked() {
        return this.tm != null && this.tm.getSimState() == 4;
    }

    public final String getCarrier() {
        String result = null;
        if (this.tm != null && this.tm.getPhoneType() != 2) {
            result = this.tm.getNetworkOperatorName().toLowerCase(Locale.getDefault());
        }
        return CheckValidityUtil.checkValidData(CheckValidityUtil.handleIllegalCharacterInResult(result));
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public final String getIMSI() {
        String result = null;
        if (this.tm != null && PermissionUtil.hasPermission(this.context, "android.permission.READ_PHONE_STATE")) {
            result = this.tm.getSubscriberId();
        }
        return CheckValidityUtil.checkValidData(result);
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public final String getSIMSerial() {
        String result = null;
        if (this.tm != null && PermissionUtil.hasPermission(this.context, "android.permission.READ_PHONE_STATE")) {
            result = this.tm.getSimSerialNumber();
        }
        return CheckValidityUtil.checkValidData(result);
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public final boolean isMultiSim() {
        return this.getActiveMultiSimInfo().size() > 1;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public final List<SubscriptionInfo> getActiveMultiSimInfo() {
        if (Build.VERSION.SDK_INT >= 22 && PermissionUtil.hasPermission(this.context, "android.permission.READ_PHONE_STATE")) {
            List tempActiveSub = SubscriptionManager.from((Context)this.context).getActiveSubscriptionInfoList();
            if (tempActiveSub == null || tempActiveSub.isEmpty()) {
                return new ArrayList<SubscriptionInfo>(0);
            }
            return tempActiveSub;
        }
        if (EasyDeviceInfo.debuggable) {
            Log.w((String)"EasyDeviceInfo", (String)"Device is running on android version that does not support multi sim functionality!");
        }
        return new ArrayList<SubscriptionInfo>(0);
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public final int getNumberOfActiveSim() {
        return this.getActiveMultiSimInfo().size();
    }
}

