/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.recyclerviewhelper;

import android.graphics.Canvas;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import github.nisrulz.recyclerviewhelper.RVHAdapter;
import github.nisrulz.recyclerviewhelper.RVHViewHolder;

public class RVHItemTouchHelperCallback
extends ItemTouchHelper.Callback {
    private final RVHAdapter mAdapter;
    private final boolean isLongPressDragEnabled;
    private final boolean isItemViewSwipeEnabledLeft;
    private final boolean isItemViewSwipeEnabledRight;

    public RVHItemTouchHelperCallback(RVHAdapter adapter, boolean isLongPressDragEnabled, boolean isItemViewSwipeEnabledLeft, boolean isItemViewSwipeEnabledRight) {
        this.mAdapter = adapter;
        this.isItemViewSwipeEnabledLeft = isItemViewSwipeEnabledLeft;
        this.isItemViewSwipeEnabledRight = isItemViewSwipeEnabledRight;
        this.isLongPressDragEnabled = isLongPressDragEnabled;
    }

    public boolean isLongPressDragEnabled() {
        return this.isLongPressDragEnabled;
    }

    public boolean isItemViewSwipeEnabled() {
        return this.isItemViewSwipeEnabledLeft || this.isItemViewSwipeEnabledRight;
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        int dragFlags = 3;
        int swipeFlags = this.isItemViewSwipeEnabledLeft && this.isItemViewSwipeEnabledRight ? 48 : (this.isItemViewSwipeEnabledRight ? 16 : 32);
        return ItemTouchHelper.Callback.makeMovementFlags((int)3, (int)swipeFlags);
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
        this.mAdapter.onItemMove(source.getAdapterPosition(), target.getAdapterPosition());
        return true;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        this.mAdapter.onItemDismiss(viewHolder.getAdapterPosition(), direction);
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        if (actionState == 1) {
            if (Build.VERSION.SDK_INT >= 11) {
                viewHolder.itemView.setTranslationX(dX);
            }
        } else {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState != 0 && viewHolder instanceof RVHViewHolder) {
            RVHViewHolder itemViewHolder = (RVHViewHolder)viewHolder;
            itemViewHolder.onItemSelected(actionState);
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public boolean canDropOver(RecyclerView recyclerView, RecyclerView.ViewHolder current, RecyclerView.ViewHolder target) {
        return current.getItemViewType() == target.getItemViewType();
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        if (viewHolder instanceof RVHViewHolder) {
            RVHViewHolder itemViewHolder = (RVHViewHolder)viewHolder;
            itemViewHolder.onItemClear();
        }
    }
}

