/*
 * Decompiled with CFR 0.152.
 */
package org.nlab.smtp.transport.connection;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportListener;
import javax.mail.internet.MimeMessage;
import org.nlab.smtp.exception.MailSendException;
import org.nlab.smtp.pool.ObjectPoolAware;
import org.nlab.smtp.pool.SmtpConnectionPool;
import org.nlab.smtp.transport.connection.ClosableSmtpConnection;

public class DefaultClosableSmtpConnection
implements ClosableSmtpConnection,
ObjectPoolAware<ClosableSmtpConnection> {
    private final Transport delegate;
    private SmtpConnectionPool objectPool;
    private final List<TransportListener> transportListeners = new ArrayList<TransportListener>();

    public DefaultClosableSmtpConnection(Transport delegate) {
        this.delegate = delegate;
    }

    @Override
    public void sendMessage(MimeMessage msg, Address[] recipients) throws MessagingException {
        this.doSend(msg, recipients);
    }

    @Override
    public void sendMessage(MimeMessage msg) throws MessagingException {
        this.doSend(msg, msg.getAllRecipients());
    }

    @Override
    public void sendMessages(MimeMessage ... msgs) throws MailSendException {
        this.doSend(msgs);
    }

    @Override
    public void addTransportListener(TransportListener l) {
        this.transportListeners.add(l);
        this.delegate.addTransportListener(l);
    }

    @Override
    public void removeTransportListener(TransportListener l) {
        this.transportListeners.remove(l);
        this.delegate.removeTransportListener(l);
    }

    @Override
    public void clearListeners() {
        for (TransportListener transportListener : this.transportListeners) {
            this.delegate.removeTransportListener(transportListener);
        }
        this.transportListeners.clear();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public void close() throws Exception {
        this.objectPool.returnObject(this);
    }

    @Override
    public SmtpConnectionPool getObjectPool() {
        return this.objectPool;
    }

    @Override
    public void setObjectPool(SmtpConnectionPool objectPool) {
        this.objectPool = objectPool;
    }

    @Override
    public Transport getDelegate() {
        return this.delegate;
    }

    @Override
    public Session getSession() {
        return this.objectPool.getSession();
    }

    private void doSend(MimeMessage mimeMessage, Address[] recipients) throws MessagingException {
        if (mimeMessage.getSentDate() == null) {
            mimeMessage.setSentDate(new Date());
        }
        String messageId = mimeMessage.getMessageID();
        mimeMessage.saveChanges();
        if (messageId != null) {
            mimeMessage.setHeader("Message-ID", messageId);
        }
        this.delegate.sendMessage((Message)mimeMessage, recipients);
    }

    private void doSend(MimeMessage ... mimeMessages) throws MailSendException {
        LinkedHashMap<Object, Exception> failedMessages = new LinkedHashMap<Object, Exception>();
        for (int i = 0; i < mimeMessages.length; ++i) {
            MimeMessage mimeMessage = mimeMessages[i];
            try {
                this.doSend(mimeMessage, mimeMessage.getAllRecipients());
                continue;
            }
            catch (Exception ex) {
                failedMessages.put(mimeMessage, ex);
            }
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }
}

