/*
 * Decompiled with CFR 0.152.
 */
package org.nlab.smtp.transport.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportListener;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.nlab.smtp.transport.connection.ClosableSmtpConnection;
import org.nlab.smtp.transport.connection.DefaultClosableSmtpConnection;
import org.nlab.smtp.transport.strategy.ConnectionStrategy;
import org.nlab.smtp.transport.strategy.TransportStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpConnectionFactory
implements PooledObjectFactory<ClosableSmtpConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(SmtpConnectionFactory.class);
    protected final Session session;
    protected final TransportStrategy transportFactory;
    protected final ConnectionStrategy connectionStrategy;
    protected Collection<TransportListener> defaultTransportListeners;

    public SmtpConnectionFactory(Session session, TransportStrategy transportStrategy, ConnectionStrategy connectionStrategy, Collection<TransportListener> defaultTransportListeners) {
        this.session = session;
        this.transportFactory = transportStrategy;
        this.connectionStrategy = connectionStrategy;
        this.defaultTransportListeners = defaultTransportListeners;
    }

    public SmtpConnectionFactory(Session session, TransportStrategy transportFactory, ConnectionStrategy connectionStrategy) {
        this(session, transportFactory, connectionStrategy, Collections.emptyList());
    }

    public PooledObject<ClosableSmtpConnection> makeObject() throws Exception {
        LOG.debug("makeObject");
        Transport transport = this.transportFactory.getTransport(this.session);
        this.connectionStrategy.connect(transport);
        DefaultClosableSmtpConnection closableSmtpTransport = new DefaultClosableSmtpConnection(transport);
        this.initDefaultListeners(closableSmtpTransport);
        return new DefaultPooledObject((Object)closableSmtpTransport);
    }

    public void destroyObject(PooledObject<ClosableSmtpConnection> pooledObject) throws Exception {
        try {
            LOG.debug("destroyObject [{}]", (Object)((ClosableSmtpConnection)pooledObject.getObject()).isConnected());
            ((ClosableSmtpConnection)pooledObject.getObject()).clearListeners();
            ((ClosableSmtpConnection)pooledObject.getObject()).getDelegate().close();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    public boolean validateObject(PooledObject<ClosableSmtpConnection> pooledObject) {
        LOG.debug("Is connected [{}]", (Object)((ClosableSmtpConnection)pooledObject.getObject()).isConnected());
        return ((ClosableSmtpConnection)pooledObject.getObject()).isConnected();
    }

    public void activateObject(PooledObject<ClosableSmtpConnection> pooledObject) throws Exception {
        LOG.debug("activateObject [{}]", (Object)((ClosableSmtpConnection)pooledObject.getObject()).isConnected());
        if (!((ClosableSmtpConnection)pooledObject.getObject()).isConnected()) {
            throw new Exception("Transport is not connected");
        }
        this.initDefaultListeners((ClosableSmtpConnection)pooledObject.getObject());
    }

    public void passivateObject(PooledObject<ClosableSmtpConnection> pooledObject) throws Exception {
        LOG.debug("passivateObject [{}]", (Object)((ClosableSmtpConnection)pooledObject.getObject()).isConnected());
        ((ClosableSmtpConnection)pooledObject.getObject()).clearListeners();
    }

    public void setDefaultListeners(Collection<TransportListener> listeners) {
        this.defaultTransportListeners = new CopyOnWriteArrayList<TransportListener>(Objects.requireNonNull(listeners));
    }

    public List<TransportListener> getDefaultListeners() {
        return new ArrayList<TransportListener>(this.defaultTransportListeners);
    }

    public Session getSession() {
        return this.session;
    }

    private void initDefaultListeners(ClosableSmtpConnection smtpTransport) {
        for (TransportListener transportListener : this.defaultTransportListeners) {
            smtpTransport.addTransportListener(transportListener);
        }
    }
}

