/*
 * Decompiled with CFR 0.152.
 */
package org.nlab.smtp.transport.strategy;

import javax.mail.MessagingException;
import javax.mail.Transport;
import org.nlab.smtp.transport.strategy.ConnectionStrategy;

public class ConnectionStrategyFactory {
    public static ConnectionStrategy newConnectionStrategy() {
        return new ConnectionStrategy(){

            @Override
            public void connect(Transport transport) throws MessagingException {
                transport.connect();
            }
        };
    }

    public static ConnectionStrategy newConnectionStrategy(final String username, final String password) {
        return new ConnectionStrategy(){

            @Override
            public void connect(Transport transport) throws MessagingException {
                transport.connect(username, password);
            }
        };
    }

    public static ConnectionStrategy newConnectionStrategy(final String host, final String username, final String password) {
        return new ConnectionStrategy(){

            @Override
            public void connect(Transport transport) throws MessagingException {
                transport.connect(host, username, password);
            }
        };
    }

    public static ConnectionStrategy newConnectionStrategy(final String host, final int port, final String username, final String password) {
        return new ConnectionStrategy(){

            @Override
            public void connect(Transport transport) throws MessagingException {
                transport.connect(host, port, username, password);
            }
        };
    }
}

